/* hardware.h */

/* state of the CD-ROM hardware */
typedef struct {
    int    iStatus;                        /* see CD_STATUS* below */
    int    iData;
    int    iAudio;
    struct cdrom_tochdr tochdr;            /* from CDROMREADTOCHDR */
    struct cdrom_tocentry tocentries[100]; /* from CDROMREADTOCENTRY */
    struct cdrom_subchnl subchnl;          /* from CDROMSUBCHNL */
} cdhw_t;

/* procedures */
cdhw_t *read_hw(char *progname, int cdfile, char *cdname);
int     checkmount(char *progname, char *pszName);
int     cd_status(char *progname, int cd_fd, char *cdname, cdhw_t *pHw);
void    free_hw_buf(cdhw_t *pHw);
char   *cd_status_text (int iStatus);

/* additional error codes, see linux/cdrom.h */
#define NO_CDROM         200
#define CDROM_MOUNTED    201
#define CDROM_DATA_DISC  202

/* return codes from cd_status */
#define CD_STATUS_ERROR    -1
#define CD_STATUS_NO_CD     0
#define CD_STATUS_CD_IN     1
#define CD_STATUS_INSERTED  2
#define CD_STATUS_REMOVED   3
#define CD_STATUS_MOUNTED   4
#define CD_STATUS_DATA_DISC 5


