;;; -*- lisp -*- system definition

(defpackage #:iterate.system
  (:use #:cl #:asdf))

(in-package #:iterate.system)
  
(defsystem iterate
    :components ((:file "package")
		 (:file "iterate" :depends-on ("package"))))

(defsystem iterate-pg
    :depends-on (iterate pg)
    :components ((:file "iterate-pg")))

(defsystem iterate-tests
    :depends-on (#+sbcl sb-rt
		 #-sbcl rt
		 iterate)
    :components ((:file "iterate-test")))

(defmethod perform ((op asdf:test-op) (c (eql (find-system 'iterate))))
  (operate 'asdf:load-op 'iterate-tests)
  (operate 'asdf:test-op 'iterate-tests))

(defmethod perform ((op asdf:test-op) (c (eql (find-system 'iterate-tests))))
  (funcall (intern "DO-TESTS" (find-package #+sbcl "SB-RT"
					    #-sbcl "RT"))))

(defmethod perform :after ((o load-op) (c (eql (find-system 'iterate))))
  (provide '#:ITERATE))

;;; arch-tag: "b8bc9675-313c-11d8-abb9-000c76244c24"
