;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: uri.lisp,v 1.3 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 2000 - 2003 onShore Development, Inc.

;;;
;;; URI and HTML-related procedures
;;;

(in-package :odcl)

(defvar *html-escape-map*
  '((#\< . "&lt;")
    (#\> . "&gt;")
    (#\& . "&amp;")))

;; URI escaping
(defun uri-graphic-character (a)
  (member a '(#\;
              #\/
              #\?
              #\:
              #\@
              #\&
              #\=
              #\+
              #\$
              #\,
              #\_
              #\.
              #\!
              #\~
              #\*
              #\'
              #\(
              #\))))

(defun uri-reserved-character (a)
  (member a '(#\;
              #\/
              #\?
              #\:
              #\@
              #\&
              #\=
              #\+
              #\$
              #\,)))

(deftype uri-character ()
  '(and character
    (or
     (satisfies alphanumericp)
     (satisfies uri-graphic-character))))

(deftype uri-character-reserved ()
  '(and character
    (satisfies uri-reserved-character)))

(defun uri-escape-character (a)
  (format nil "%~x" (char-code a)))

(defun uri-unescape-character (str)
  (assert (typep str '(string 3)) (str)
          "Escape sequence of ill-formed.")
  (code-char (read-from-string (concatenate 'string "#x" (subseq str 1 3)))))

;; for use with escape-string.  it only returns a value if the
;; character needs to be escaped.  A character needs to be escaped if
;; it is not a uri character, or if it is a reserved one.
(defun uri-string-escaper (ch)
  (if (typep ch 'uri-character)
      (when (typep ch 'uri-character-reserved)
        (uri-escape-character ch))
      (uri-escape-character ch)))

;; Taken from htout.lisp by Tim Bradshaw (tfb at KINGSTON)
;; Handling of function as map add by Craig Brozefsky
;; Perhaps it should be a seperate function?
(defun uri-escape-string (string)
  (escape-string string #'uri-string-escaper))

(defun uri-unescape-string (string)
  (declare (type string string))
  (with-output-to-string (o)
    (loop for prev = 0 then (+ found 3)
          for found = (position #\%
                                string
                                :start prev)
          while found
          do
          (write-sequence string o :start prev :end found)
          (write-char (uri-unescape-character (subseq string found (+ found 3))) o)
          finally
          (write-sequence string o :start prev :end (length string)))))
