#!/usr/local/bin/perl
#
# cmail-mksum.pl - cmail  Folder  summary 
#           
#  Author: nagano@ose.west.enicom.co.jp ( Takashi Nagano )
#
#  Fri Nov 12 11:17:23 JST 1993 - matz
#   ѿޤɽoץĤ.
#   ʣԤΥեɤбǤ褦ʵ.
#   Dateեɤβʬ.
#
#  ver 0.1 - Date:   Wed, 10 Nov 93 18:50:00
#   ΤޤޤǤϡ2 Ԥˤʤä Subject бǤʤ⤷ʤ   
#

#############################################################################
#
# ʸν
#
#     ƴĶˤ碌ѹƤ
#
#############################################################################
#
# ե̾ 
#
$TMP_FILE = "/tmp/cmail-mksum.$$";

#############################################################################
# ʲϡѹʤǤ
#############################################################################

$PAGE_SEP = "\n";		# cmail γ mail ֤Υѥ졼
$STATUS_LINE = "X-cmail-status:"; # cmail  status-line

# mail-header γƹܤƬ 
$FROM = "From:";
$SUBJECT = "Subject:";
$XSUB = "X-Nsubject:";
$DATE = "Date:";

#############################################################################
#
# ץ
#
#############################################################################

# ѴѤϢ
%exch_month = (       
	       'jan', '01', 'feb', '02', 'mar', '03',
	       'apr', '04', 'may', '05', 'jun', '06',
	       'jul', '07', 'aug', '08', 'sep', '09',
	       'oct', '10', 'nov', '11', 'dec', '12',
	       );

$SIG{'PIPE'} = 'clean';

# ե open 
$OUT = "> $TMP_FILE";
open( TMPFILE, $OUT ) || die "Can't open $TMP_FILE: $!\n";

$OUT_MAILNO = 1;
while (<>) {
    print TMPFILE;		# ȤꤢƤϤե
    if ( /^[ \t]/ ) {
	chop($f);
	$f .= ' ' . $_;
    }
    else {
	$OUT_STATUS = &make_status($f) if ($f =~ /^$STATUS_LINE/o); 
	$OUT_FROM   = &make_from($f) if ($f =~ /^$FROM/o); 
	$OUT_DATE   = &make_date($f) if ($f =~ /^$DATE/o);
	$OUT_SUBJ   = &make_subject($f) if ($f =~ /^$SUBJECT/o);
	$OUT_XSUB   = &make_subject($f) if ($f =~ /^$XSUB/o);
	$f = $_;
    }

    if ( $_ eq "\n" ) {
	$OUT_COUNT  = &end_header;       
	print( "$OUT_MAILNO $OUT_STATUS $OUT_DATE $OUT_FROM " );
	print( "$OUT_COUNT \[$OUT_SUBJ\]\n" );
	$OUT_MAILNO++;
    }
}
close TMPFILE;

open( TMPFILE, $TMP_FILE ) || die "What ??: $!\n";

while (<TMPFILE>) {
    print;
}
close TMPFILE;
&clean;

sub clean {
    unlink $TMP_FILE;
}

sub make_status { # status-line ν
    local($tmp) = @_;
    split(' ', $tmp);
    substr($_[1], 0, 1);
}

sub make_from {
    local($tmp) = @_;
    chop($tmp);
    ($E_add) = ($tmp =~ /\<(.*)\>/ );
    if (!$E_add) {
	$E_add = &get_EG($tmp, "\\(", "\\)"); 
	($Gcos) = ($tmp =~ /\((.*)\)/ );
	$Gcos = $E_add if (!$Gcos);
    } else {
	$Gcos = &get_EG($tmp, "\\<", "\\>");
    }
    $OUT_FROM = "$Gcos <$E_add>";
}

sub get_EG {
    local($etmp, $f, $e) = @_;   
    local(@fr) = split(' ', $etmp);
    shift(@fr);
    local($chk) = 0;
    local(@e_tmp);
    foreach $N ( @fr ) {
	$chk = 1 if ( $N =~ /^$f/ );
	push( @e_tmp, $N ) if (!$chk);  
	$chk = 0 if ( $N =~ /$e$/ );
    } 
    join(' ', @e_tmp);
}

sub make_date {
    local($tmp) = @_;
    local($day, $t_month, $year);
    $tmp =~ /^Date: ([A-Za-z]+, )?([0-9]+) ([A-Za-z]+) ([0-9]+)/;
    $day = $2;
    $t_month = $3;
    $year = substr($4, -2);
    $day = sprintf("%02d", $day);
    local($x_month) = substr($t_month, 0, 3);
    $x_month =~ tr/A-Z/a-z/;
    $month = $exch_month{$x_month};
    return "$year/$month/$day";
}

sub make_subject {
    local($tmp) = @_;
    split(' ', $tmp);
    shift;
    join( ' ', @_ );
}

sub end_header {
    local($count) = 0;
    while (<>) {
	print TMPFILE;
	last if ( /^$PAGE_SEP/o );
	$count++;
    } 
    return $count;
}
