%{
#include "cint.h"
#include "cint-par-tab.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
%}
%option noyywrap

id	[a-zA-Z_][a-zA-Z0-9_]*
space	[ \t\v\f\r\n]
D	[0-9]
W	{space}*
comment "/*"([^*]*"*"[^/])*[^*]*"*/"

%o 5000

%%

if		return IF;
else		return ELSE;
while		return WHIL;
return		return RETN;
int		return INT;
{id}		{yylval.id  = strdup(yytext); return ID;}
{D}+    	{yylval.num = atoi(yytext); return NUM;}
{space}*        { }
{comment}       { }
"<="		return LEQ;
">="		return GEQ;
"=="		return EQL;
"!="		return NEQ;
.               return yytext[0];

%%

char* strdup(const char* source) {
  char* dest = (char*)malloc((strlen(source) + 1) * sizeof(char));
  strcpy(dest, source);
  return dest;
}

