/*
 *  PPP session Controller
 */

#import <Foundation/NSObject.h>
#import "PPPSessionMethods.h"

@class NSTask;
@class NSString;

@class SessionWindow;

@interface PPPSession : NSObject <PPPSessionMethods>
{
  NSTask            *task;
  NSFileHandle      *outputFile;
  NSFileHandle      *inputFile;
  NSPipe            *errorPipe;
  NSFileHandle      *errorFileIn;
  NSFileHandle      *errorFileOut;
  NSMutableArray    *args;
  
  NSString          *portName;
  NSString          *portSpeed;
  NSArray           *phoneNumbers;
  NSMutableString   *chatScriptPath;
  NSMutableString   *pppdOptionsPath;
  NSMutableString   *portSettings;

  SessionWindow     *clientObject;
}

- (id) initWithClientObject: (id)anObject;

- (int) savePort;

- (int) setPort;

- (int) restorePort;

- (int) runChat;

- (int) runPPPD;

@end

