/*****************************************************************
 *
 *   xcin.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "defaults.h"

#define XCINRC_PATH "/etc/xcinrc"

void write_xcinrc(void);

extern gboolean start_mainwin2;
extern gboolean xcin_hide;
extern gboolean disable_wm_ctrl;
extern gboolean overspot_use_fontset;
extern gboolean overspot_window_only;

GtkWidget *check_button_1;
GtkWidget *check_button_2;
GtkWidget *check_button_3;
GtkWidget *check_button_4;
GtkWidget *check_button_5;

void write_xcinrc(void)
{
	FILE *f_src;
	FILE *f;
	gchar str[STR_BUFFER_SIZE];
	gchar temp_str[STR_BUFFER_SIZE];
	gint len,c;
	gchar *str_ptr;
	gchar first_word[STR_BUFFER_SIZE];

	f_src = fopen(XCINRC_PATH,"r");
	f = fopen(g_strconcat(getenv("HOME"),"/.xcinrc",NULL),"w");
	if(!f_src)
	{
		fprintf(stderr,"Error opening xcinrc source file: %s\n",XCINRC_PATH);
		return;
	}
	if(!f)
	{
		fprintf(stderr,"Error writing ~/.xcinrc file\n");
		return;
	}

	while(fgets(str,STR_BUFFER_SIZE,f_src))
	{
		strcpy(temp_str,str);
		len = strlen(temp_str);
		c = 0;

		while(temp_str[c]==' ' && c<len) c++;
		if(temp_str[c]==';')
		{
			fprintf(f,str);
			continue;
		}

		str_ptr = temp_str + c;

		while(temp_str[c]!=' ' && c<len) c++;
		temp_str[c] = '\0';
		
		strcpy(first_word,str_ptr);
		if(!strcasecmp(first_word,"(define"))
		{
			c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"START_MAINWIN2"))
				fprintf(f,"(define START_MAINWIN2\t\"%s\")\n",start_mainwin2?"YES":"NO");
			else if(!strcasecmp(first_word,"XCIN_HIDE"))
				fprintf(f,"(define XCIN_HIDE\t\"%s\")\n",xcin_hide?"YES":"NO");
			else if(!strcasecmp(first_word,"DISABLE_WM_CTRL"))
				fprintf(f,"(define DISABLE_WM_CTRL\t\"%s\")\n",disable_wm_ctrl?"YES":"NO");
			else if(!strcasecmp(first_word,"OVERSPOT_USE_USRFONTSET"))
				fprintf(f,"(define OVERSPOT_USE_USRFONTSET\t\"%s\")\n",overspot_use_fontset?"YES":"NO");
			else if(!strcasecmp(first_word,"OVERSPOT_WINDOW_ONLY"))
				fprintf(f,"(define OVERSPOT_WINDOW_ONLY\t\"%s\")\n",overspot_window_only?"YES":"NO");
			else
				fprintf(f,str);
		}
		else
			fprintf(f,str);
	}
	fclose(f);
	fclose(f_src);
}

void ok_xcin(GtkWidget *button, gpointer *data)
{
	start_mainwin2 = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_1));
	xcin_hide = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_2));
	disable_wm_ctrl = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_3));
	overspot_use_fontset = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_4));
	overspot_window_only = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button_5));

	write_xcinrc();
}

void def_xcin(GtkWidget *button, gpointer *data)
{
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_button_1),START_MAINWIN2);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_button_2),XCIN_HIDE);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_button_3),DISABLE_WM_CTRL);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_button_4),OVERSPOT_USE_FONTSET);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_button_5),OVERSPOT_WINDOW_ONLY);
}

void help_xcin(GtkWidget *button, gpointer *data)
{
	show_help("xcin_opt",_("Help - xcin Options"),600,300);
}

/* no use after cpanel 0.4.0 
void xcin(GtkWidget *button, gpointer *data)
{
	gchar *command;

	command = g_strconcat(xcin_command," -x ",xcin_im," &",NULL);
	system(command);
}
*/

void xcin_opt(GtkWidget *button, gpointer *data)
{
	/* entry[]: 0.command 1.im */
	GtkWidget *win;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *def_button;
	GtkWidget *help_button;
	GtkWidget *separator;
	GtkWidget *label;

	win = make_opt_win(_("Options - xcin"),button);

	vbox = gtk_vbox_new(FALSE,0);

	check_button_1 = make_check_opt(_("Use floating window"),start_mainwin2);
	gtk_box_pack_start(GTK_BOX(vbox),check_button_1,FALSE,FALSE,5);
	check_button_2 = make_check_opt(_("Hide xcin main window"),xcin_hide);
	gtk_box_pack_start(GTK_BOX(vbox),check_button_2,FALSE,FALSE,5);
	check_button_3 = make_check_opt(_("Disable border around xcin"),disable_wm_ctrl);
	gtk_box_pack_start(GTK_BOX(vbox),check_button_3,FALSE,FALSE,5);
	check_button_4 = make_check_opt(_("Use overspot window fontset"),overspot_use_fontset);
	gtk_box_pack_start(GTK_BOX(vbox),check_button_4,FALSE,FALSE,5);
	check_button_5 = make_check_opt(_("Use overspot window only"),overspot_window_only);
	gtk_box_pack_start(GTK_BOX(vbox),check_button_5,FALSE,FALSE,5);

	label = gtk_label_new(_("Please restart X after configuring Xcin"));
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,2);

        ok_button = gtk_button_new_with_label(_("OK"));
        gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
                        GTK_SIGNAL_FUNC(ok_xcin),NULL);

        cancel_button = gtk_button_new_with_label(_("Cancel"));

        def_button = gtk_button_new_with_label(_("Use Defaults"));
        gtk_signal_connect(GTK_OBJECT(def_button),"clicked",
                        GTK_SIGNAL_FUNC(def_xcin),NULL);

        help_button = gtk_button_new_with_label(_("Help"));
        gtk_signal_connect(GTK_OBJECT(help_button),"clicked",
                        GTK_SIGNAL_FUNC(help_xcin),NULL);

	/* Separator */
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);

        /* Make buttons: make_button(ok,canel,def,help,win); */
        hbox = make_button(ok_button,cancel_button,def_button,help_button,
			win,button);
        gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

        /* show window */
        gtk_container_add(GTK_CONTAINER(win),vbox);
        gtk_widget_show_all(win);
}

void xcin_help(GtkWidget *button, gpointer *data) {
	show_help("xcin_README",_("Help - xcin"),700,600);
}
