<?php
/**
 * This class handles all submitting of comments.
 * Currently only news are supported...
 * but sooner webcam, tips, and poll will be :)
 *
 * daCode http://www.dacode.org/
 * src/phplib/submitComments.php3
 * $Id: submitComments.php3,v 1.14.2.11 2002/11/05 22:58:31 ruffy Exp $
 */
class SubmitComments {

	/**
	 * The comments class used for rendering
	 *@var object Comments $comments
	 */
	var $comments;

	/**
	 * The utils class. Used for debug functions
	 *@var object Utils $utils
	 */
	var $utils;

	/**
	 *The resource ID to comment
	 *@var int $res_id
	 */
	var $res_id;

	/**
	 *The resource type to comment
	 *@var int $res_type
	 */
	var $res_type;

	/**
	 *The comment to be replied to
	 *@var int $com_id ID of the comment
	 */
	var $com_id;

	/**
	 * Constructor
	 */
	Function SubmitComments () {
		global $config;
		$this->comments = LoadClass("Comments", 1);
		$this->utils = LoadClass("Utils");
	}

	/**
	 * Sets the resource ID and resource type to comment...
	 * Initialize the comments class...
	 *@param int $res_id the resource ID
	 *@param int $res_type the resource type
	 *@access private
	 */
	Function setResource($res_id, $res_type) {
		$this->utils->debug("submitComments:".__LINE__." setResource: start; res_id=".
			$res_id."; res_type=".$res_type.";\n");
		$this->res_id = $res_id;
		$this->res_type = $res_type;
		$this->comments->init($res_id, $res_type, $com_id);
	}

	/**
	 * Check if the resource is to be commented. FIXME: Does not check wether
	 * the comment has the correct ressource type.
	 *@param integer $res_id the id of the commented item
	 *@param integer $com_id the id of the comment to which we reply.
	 *@return mixed NULL if successfull, string (error message) if not.
	 *@access private
	 */
	Function isAllowed($res_id, $com_id = 0) {
		//Precondition: the topic has been instanciarted
		//assert (is_object($this->topic));
		$this->utils->debug("SubmitComments:".__LINE__." isAllowed: start; res_id=".
			$res_id."; com_id=".$com_id.";\n");

		if (!is_object($this->topic)) {
			die("Must instanciate topic before using SubmitComment::isAllowed");
		}

		//Check if the resource is to be commented
		$checkError = $this->topic->checkResource($res_id);
		if (!empty($checkError)) return $checkError;

		// We check if the comment exists.
		if (isset($com_id) & $com_id != 0) {
			$sqlc_q = "SELECT id FROM comments WHERE ".
				"id='".addslashes($com_id)."' AND ".
				"news_id='".addslashes($res_id)."'";
			$ret = $this->comments->db->query($sqlc_q);
			if (!$ret) return $this->comments->db->error();
			list($com_id_ok) = $this->comments->db->fetch_array();
			$this->comments->db->free();
			if (! $com_id_ok) {
				return lecho("Sorry, no results.")." : ".
					lecho("Comment")." ".
					lecho("Not Found");
			}
		}
	}



	/**
	 *reminds the topic to be commented
	 *@param int $res_type the resource type
	 *@param int $res_id the resource ID to be commented
	 *@return string the HTML to be displayed
	 *@access public
	 */
	Function remindTopic($res_type, $res_id) {
		global $config;

		$this->utils->debug("submitComments:".__LINE__." remindTopic: start; res_type=".
			$res_type."; res_id=".$res_id.";\n");
		$this->res_id = $res_id;
		$this->res_type = $res_type;
		//echo "<h1> RES_YTPE : $res_type class".var_dump( $config->resources) ." --</h1>";
		$this->topic = LoadClass($config->resources[$res_type]);
			$res = $this->topic->viewResource($res_id);
		return $res;
	}

	/**
	 *Previews the comment, includes previous comment if applicable
	 *@param int $com_id id of the comment to be replied to
	 *@param array $table previous answers
	 *@return string the HTML to be displayed
	 *@access public
	 */
	Function previewComment($com_id,$table) {
		global $config, $res_id, $res_type;
		
		//Init some vars
		$sig = "";

		$this->utils->debug("submitComments:".__LINE__." previewComment: start; com_id=".
			$com_id."; table=\n");
		$this->utils->debug_dump($table);
		$this->utils->debug("\n");

		$config->news_id = $res_id;
		$config->res_type = $res_type;
		$this->com_id = $com_id;

		// If anonymous comment isn't allowed
		if (!$config->anonymous_comments &&
			!$this->comments->session->checked) {
			return;
		}
		// If user has a lower karma.
		if ($this->comments->session->experience < $config->experience_limit) {
			return;
		}

		// we calculate the preview of our future comment
		if  ($this->comments->session->checked &&
				(!isset($table['anon']) || !$table['anon'])) {
			/*
			$score = 1;
			$perso = $this->comments->user->identity().
				' ( #'.$this->comments->session->user_id.' ) '.
				'<img alt="message" src="'.$this->comments->session->imgurl('mail').
				'" />';
			if ($this->comments->user->get_sig($this->comments->session->sig_id)) {
				$sig = "<br /><br />-- <br />".$this->comments->user->signature;
			} else {
				$sig = "";
			}
			*/
			$score = 1;
			$perso = $this->comments->user->identity().
				' ( <a href="'.$config->basehref.'users/?a=vu&amp;user_id='.
				$this->comments->session->user_id.'">#'.$this->comments->session->user_id;
			if ($config->moderation_type == "2") {
				$perso .= ' / '.$this->comments->user->get_xp($this->comments->session->user_id).' XP ';
			}
			$perso .= '</a> ) <img alt="message" src="'.
				$this->comments->session->imgurl('mail').'" />';
			if ($this->comments->user->get_sig($this->comments->session->sig_id)) {
				$sig = "<br /><br />-- <br />".nl2br($this->comments->user->signature);
			}

		} else {
			$perso = lecho("Anonymous");
			$score = 0;
		}
		if (isset($table['troll']) && $table['troll']) {
			$score = -1;
		}
		$perso .= " - ". $this->comments->utils->stamp2date(date("YmdHis"),"long") .
		"<br />\n";
		if (empty($table['subject'])) {
			$subject = lecho("Check your text here...");
		} else {
			$subject = $table['subject'];
		}
		$preview = "  <span class=\"newstext\">\n".
			"   <b>\n".
			"    ".$this->comments->utils->htmlspecial($subject)."\n".
			"   </b>\n".
			'   ('.lecho("Score").': '.$score.")\n".
			"   <br />\n".
			"   ".lecho("Added by")." ". $perso . "\n".
			"   <br />\n".
			"    ".nl2br($this->comments->utils->htmlspecial(isset($table['body'])?$table['body']:'',1)).
			"\n".
			"    ".$sig."\n".
			"  </span>\n".
			"  <br />\n";
		// and now we can print the box.
		// maybe there is an upper comment that we can integrate?
		//
		if ($com_id) {
			// yes, the upper comment is integrated in the preview
			$this->comments->init($this->res_id,$com_id, $this->res_type);  // we get its info.
			$preview = $this->comments->html->simplebox(
				$this->comments->ac(
					$this->comments->comments[0],
					$this->comments->comments[0]['news_id'],
					$this->comments->comments[0]['res_type'],
					"full"
					)."\n".
				"<br />\n".
				"<ul>\n".
				" <li>\n".
					$preview.
				" </li>\n".
				"</ul>\n");
		} else {
			// there is no upper comment,
			// so the preview is simple...
			//
			$preview = $this->comments->html->simplebox($preview);
		}
		//echo "</td></tr></table>\n";
		return $preview;
	}


	/**
	 * Displays the form to submit a comment
	 *@param int $com_id the comment's id we're replying to
	 *@return string the HTML to be displayed
	 *@access public
	 */
	Function displayForm($com_id) {
		global $config;
		global $HTTP_POST_VARS;

		$this->utils->debug("submitComments:".__LINE__." displayForm: start; com_id=".
			$com_id."\n");

		// If anonymous comment isn't allowed
		if (!$config->anonymous_comments &&
			!$this->comments->session->checked) {
			return lecho ("Anonymous comments are not allowed");
		}
		// If user has a lower karma.
		if ($this->comments->session->experience < $config->experience_limit) {
			return lecho ("You need a higher karma to post");
		}

		$pass = 1;
		$table = (isset($HTTP_POST_VARS['table'])?$HTTP_POST_VARS['table']:"");
		$table2 = (isset($HTTP_POST_VARS['table2']))?$HTTP_POST_VARS['table2']:"";;

		$check_error = $this->isAllowed($this->res_id, $com_id);
		if (!empty($check_error)) {
			return $check_error;
		}

		if (is_array($table)) {
			//  Check whether $table and $table2 are identical
			//  but we except the field 'stack_history'
			$newstack = $table['stack_history'] + 1;
			$table['stack_history'] = $table2['stack_history'];
			// Removes the \r that Opera 5.* under Linux adds each time we submit
			// + extra spaces we don't need
			$table['body'] = ereg_replace("[ \r]+\n", "\n", $table['body']);
			$table2['body'] = ereg_replace("[ \r]+\n", "\n", $table2['body']);
			if ($this->comments->utils->cmp_array($table,$table2)) {
				$table['stack_history'] = $newstack;
				return $this->submit_confirm($table);
			} else {
				$table['stack_history'] = $newstack;
				$pass = 2;
			}
		} else {
			$table = array();
			$table['body'] = "";
			$table['troll']= "";
			$table['stack_history'] = "";
		}

		if ($pass == 1) {
			if (!empty($com_id)) {
				$temposub = $this->comments->get_subject($com_id);
				if (ereg("^Re: ",$temposub)) {
					$table['subject'] = $temposub;
				} else {
					$table['subject'] = "Re: ".$temposub;
				}
			}
			$subject =  (isset($table['subject'])) ? $table['subject'] : "";
		} else {
			$subject = $this->comments->utils->htmlspecial($table['subject']);
		}

		$out = "<form method=\"post\" action=\"".
			$config->basehref.$config->commaddfile."\">\n";

		// Previous answers are stored in hidden fields
		reset($table);
		while(list($key,$value)=each($table)) {
			$out .= '<input type="hidden" name="table2['.$key.']"'.
				' value="'.htmlspecialchars($table[$key]).'" />'."\n";
		}

		$out .= " <table>\n".
			"  <tr>\n".
			"   <td align=\"right\">\n".
			"    ".$this->comments->user->identity()."\n".
			"   </td>\n".
			"   <td>\n".
			"    <b>\n".
			"     [ ";

		if ($this->comments->session->checked) {
			$out .= $this->comments->session->login;
		} else {
			$out .= lecho("Anonymous")." (".lecho("You are not authenticated").
					")";
		}

		$out .= " ]\n".
			"    </b>\n".
			"   </td>\n".
			"  </tr>\n".
			"  <tr>\n".
			"   <td align=\"right\">\n".
			"    ".lecho("Subject")."\n".
			"   </td>\n".
			"   <td>\n".
			'    <input type="text" name="table[subject]" value="'.
			$subject.'" size="50" maxlength="80" />'."\n".
			"   </td>\n".
			"  </tr>\n".
			"  <tr>\n".
			"   <td valign=\"top\" align=\"right\">\n".
			"    ".ucfirst(lecho("Comment"))."\n".
			"   </td>\n".
			"   <td>\n".
			"    <textarea name=\"table[body]\" rows=\"10\" cols=\"50\">".
			$this->comments->utils->htmlspecial($table['body'])."</textarea>\n".
			"   </td>\n".
			"  </tr>\n".
			"  <tr>\n".
			"   <td>&nbsp;</td>\n".
			"   <td colspan=\"2\" align=\"right\">\n".
			"    ".
			lecho("URLs must be written http://... without &lt;a&gt; tag.  Following HTML tags are valid, but must be closed by the adequate &lt;/X&gt; tag:").
			"\n".
			($config->valid_tags ?
				'&lt;'.join('&gt; &lt;', $config->valid_tags).'&gt;' : ' nono').
			"   </td>\n".
			"  </tr>\n";

		if ($this->comments->session->checked && $config->anonymous_comments) {
			$out .= "  <tr>\n   <td>&nbsp;</td>\n   ".
				"<td colspan=\"2\" align=\"left\">\n".
				'    <input type="checkbox" name="table[anon]" value="1"';
			if (isset($table['anon']) && $table['anon']) {
				$out .= ' checked="checked"';
			}
			$out .= '" />&nbsp;'.lecho("Post Anonymously")."\n".
				"   </td>\n  </tr>\n";
		}
		$out .= "  <tr>\n   <td>&nbsp;</td>\n   <td colspan=\"2\" ".
			"align=\"left\">\n".
			'    <input type="checkbox" name="table[troll]" value="1"'.
			((isset($table['troll'])&&$table['troll']) ? ' checked="checked"' : '').
			'" />&nbsp;'.lecho("Score")." -1\n </td>\n  </tr>\n";

		$out .= "  <tr>\n   <td colspan=\"3\" align=\"center\">\n".
			'    <input type="submit" name="submit" value="'.lecho("Next").
			'" />'."\n".
			"   </td>\n".
			"  </tr>\n".
			" </table>\n".
			' <input type="hidden" name="table[stack_history]" value="'.
			$table['stack_history'].'" />'."\n".
			' <input type="hidden" name="table[news_id]" value="';


		//Maybe a bug???
		if (!empty($table['news_id'])) {
			$out .= $table['news_id'];
		} elseif (!empty($this->res_id)) {
			$out .= $this->res_id;
		}
		$out .= '" />'."\n";

		if (!empty($table['res_type'])) {
			$out .= '<input type="hidden" name="table[res_type]"  value="' .
				$table['res_type'] . '" />' . "\n";
		} elseif (!empty($this->res_type)) {
			$out .= '<input type="hidden" name="table[res_type]"  value="' .
				$this->res_type . '" />' . "\n";
		}



		if (ereg("^[0-9]+$",$com_id) && $com_id > 0) {
			$out .= ' <input type="hidden" name="table[com_id]" '.
				'value="'.$com_id.'" />'."\n";
		} elseif (!empty($table['com_id'])) {
			$out .= ' <input type="hidden" name="table[com_id]" value="'.
				$table['com_id'].'" />'."\n";
		}

		$out .= "</form>\n".
			'<p><center>'.lecho("Step").' '.$pass.'/3</center>';
		//echo "end submit</td></tr></table>\n";

		return $this->comments->html->simplebox($out);
	}

	/**
	 * Add a new comment. Called from /comments/add.php3
	 *@param array the table resulting from form submission
	 *@return string the HTML to be displayed
	 */
	Function submit_confirm($table) {
		global $config;

		$this->utils->debug("submitComments:".__LINE__." submit_confirm: start; table=\n");
		$this->utils->debug_dump($table);
		$this->utils->debug(";\n");

		if (!ereg("^".$config->baseurl,$this->comments->HTTP_REFERER) &&
				($this->comments->session->param & pow(2,3) == 0)) {
			//echo "</td></tr></table>\n";
			return $this->comments->utils->warn_referer() .
				"<p><center>".lecho("Step")." 3/3</center>";
		}

		if (empty($table['subject']) || empty($table['body'])) {
			//echo "</td></tr></table>\n";
			return lecho("Both subject and body must be filled").
				"<p><center>".lecho("Step")." 3/3</center>";
		}

		// If user isn't authentified and anonymous comment not allowed
		if (!$this->comments->session->user_id && !$config->anonymous_comments) {
			//echo "</td></tr></table>\n";
			return lecho("You are not authenticated").
				"<p><center>".lecho("Step")." 3/3</center>";
		}
		// If user has a lower karma.
		if ($this->comments->session->experience < $config->experience_limit) {
			return lecho("You need a higher karma to post");
		}

		$table['subject'] = $this->comments->utils->htmlspecial($table['subject']);
		$table['body'] = $this->comments->utils->htmlspecial($table['body']);

		/* We build the SQL Commands:
		 * $sqlc_q will publish the new comment and
		 * $r will check if the comment does already exist
		 */

		/*
		 * A modifier
		 */
		$sqlc_q = 'INSERT INTO '.$config->tables['comments'].
			' (subject,body,news_id,res_type,user_id,ip,com_parent,sig_id)'.
			" VALUES ('".
			addslashes($table['subject'])."','".
			addslashes($table['body'])."','".
			addslashes($table['news_id'])."'," .
			$table['res_type'] . ",'"; //$table['res_type'] MUST BE an integer!
		$sqlc_r = 'SELECT id FROM '.$config->tables['comments']." WHERE ".
			"subject='".addslashes($table['subject'])."' AND ".
			"body='".addslashes($table['body'])."' AND ".
			"news_id='".addslashes($table['news_id']). "' AND " .
			"res_type=" . $table['res_type'] . " ";

		// If anonymous is allowed and used, we go for it
		if ( ( isset($table['anon']) && $table['anon'] &&
					$config->anonymous_comments) ||
			!($this->comments->session->user_id>1)) {
			$sqlc_q .= "1";
		} else {
			$sqlc_q .= addslashes($this->comments->session->user_id);
		}

		$sqlc_q .= "','".addslashes($this->comments->utils->ip())."',";

		// Now we put parent comment
		if (isset($table['com_id']) && ereg("^[0-9]+$",$table['com_id'])
		 && $table['com_id'] > 0) {
			$sqlc_q .= "'".addslashes($table['com_id'])."',";
			$sqlc_r .= " AND com_parent='".addslashes($table['com_id'])."'";
		} else {
			$sqlc_q .= "'0',";
			$sqlc_r .= " AND com_parent='0'";
		}

		// If anonymous comment => default sig is 1
		if ( ( isset($table['anon']) && $table['anon'] &&
					$config->anonymous_comments) ||
			!($this->comments->session->user_id>1)) {
			$sqlc_q .= "'1'";
		} else {
			$sqlc_q .= "'".addslashes($this->comments->session->sig_id)."'";
		}
		$sqlc_q .= ")";

		$ret = $this->comments->db->query($sqlc_r);
		if (!$ret) {
			echo '<!-- SQL failed: '.$this->comments->db->error() . " -->\n";
			echo '<!-- SQL Command: '.$sqlc_r." -->\n";
			//echo "</td></tr></table>\n";
			return;
		}
		$count = $this->comments->db->num_rows();
		if ($count > 0) {
		echo "</td></tr></table>\n";
			return lecho("Sorry, a similar comment has already been registered for this news.  If for some reason you really want to post the same comment, you may add some spaces anywhere.");
		}

		$ret = $this->comments->db->query($sqlc_q);
		if (!$ret) {
			echo '<!-- SQL failed: '.$this->db->error() . " -->\n";
			echo '<!-- SQL Command: '.$sqlc_q." -->\n";
			//echo "</td></tr></table>\n";
			return;
		}
		$comments_id = $this->comments->db->last_insert_id();
		$sqlc_q = "INSERT INTO ".$config->tables['comments_scored'].
			" (comments_id,user_id,score,info) VALUES ('".
			addslashes($comments_id)."','1','";

		if (isset($table['troll']) && $table['troll']){
			$sqlc_q .= "-1";
		} elseif ((isset($table['anon']) && $table['anon'] && $config->anonymous_comments) ||
				!$this->comments->session->user_id) {
			$sqlc_q .= "0";
		} else {
			$sqlc_q .= "1";
		}

		$sqlc_q .= "','')";

		/* We remove the HTML pages for this news */
		$this->comments->cache->delete_obsolete_news($table['news_id']);

		$ret = $this->comments->db->query($sqlc_q);
		if (!$ret) {
			echo '<!-- SQL failed:'.$this->db->error(). " -->\n";
			echo '<!-- SQL request: '.$sqlc_q." -->\n";
		echo "</td></tr></table>\n";
			return;
		}
		/* Old version
		 *$ts = $this->comments->utils->gettimestampnews($table['news_id']);
		 *$news_url = $this->comments->session->newsurls($table['news_id'], "",
		 *		"", $ts[0], $ts[1], $ts[2])
		 *		$news_url = ereg_replace(',[^/]+$', '', $news_url);
		 */
		//New one
		$news_url = $this->topic->getTopicUrl($table['news_id'],0);
		$news_url_abs = $this->topic->getTopicUrl($table['news_id']);
		echo "</td></tr></table>\n";

		return "<div class=\"commentconfirm\">\n<p>".
			lecho("Your comment has been registered.  You can find it at the url ").
			'<a href="'.$news_url.'">'.$news_url_abs.
			"</a><br />\n".lecho("  Follow this link to come back to it by ").
			'<a href="javascript:history.go(-'.++$table['stack_history'].')">'.
			lecho("back")."</a>.<p>".
			lecho("If you don't see it on this page it means that your webbrowser put this page in its cache. You have to reload the page.")."\n".
			" <p><center>".lecho("Step")." 3/3</center>\n".
			"</div>\n";
	}

}

?>
