"""Access to darkstat API.

This file is a part of darkstat (http://purl.org/net/darkstat)
Author: Oleg Broytmann <phd@phd.pp.ru>
License: GPL
"""


DEFAULT_HOST = "localhost"
DEFAULT_PORT = 666


from httplib import HTTPConnection

class DarkstatAPI(HTTPConnection):
   def __init__(self, host=DEFAULT_HOST, port=DEFAULT_PORT, strict=None):
      HTTPConnection.__init__(self, host, port, strict)


   def get(self, url):
      self.connect()
      self.request("GET", url)
      response = self.getresponse()
      lines = response.read().split("\n")
      self.close()
      return response, lines


   def get_total_bytes(self):
      return self.get(self.info_total_bytes_url)[1]
