#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "gui_layout.h"
#include "graph.h"
#include "main.h"
#include "misc_gtk.h"
#include "done_clist.h"

void
on_graph_by_weekdayradiobutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_dl_type=GRAPH_BY_WEEKDAY;
	build_graph_image(-1,-1);

	if(graph_dl_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_dl_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


void
on_graph_by_monthdayradiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_dl_type=GRAPH_BY_MONTHDAY;
	build_graph_image(-1,-1);

	if(graph_dl_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_dl_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


void
on_redraw_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	/* reload the list in memory, update the displayed list and update the graphic */
	load_all_done_lists();

	/* create the new graphic */
	build_graph_image(-1,-1);

	/* and display it */
	if(graph_dl_image!=NULL)
	{
		GtkWidget *widget;

		widget=get_widget_by_widget_name(main_window,"graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_dl_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


gboolean
on_graph_drawingarea_expose_event      (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	if((graph_dl_image==NULL)||(graph_image_w!=widget->allocation.width)||(graph_image_h!=widget->allocation.height))
	{
		if(graph_depth==-1)
		{
	   	graph_depth=gdk_drawable_get_depth(widget->window);
		}
		build_graph_image(widget->allocation.width, widget->allocation.height);
	}

	if(graph_dl_image!=NULL)
	{
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_dl_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
	return FALSE;
}


void
on_clear_global_list_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	delete_all_done_lists();

	/* and refresh the display */
	load_all_done_lists();

	/* create the new graphic */
	build_graph_image(-1,-1);
}


void
on_reload_done_list_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	/* reload the list in memory, update the displayed list and update the graphic */
	load_all_done_lists();

	/* create the new graphic */
	build_graph_image(-1,-1);
}


void
on_display_by_transfer_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_dl_display_type=GRAPH_BY_TRANSFER;
	build_graph_image(-1,-1);

	if(graph_dl_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_dl_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


void
on_display_by_size_radiobutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_dl_display_type=GRAPH_BY_SIZE;
	build_graph_image(-1,-1);

	if(graph_dl_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_dl_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


gboolean
on_root_notebook_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gui_full_save(widget,NULL);
	gtk_widget_destroy(widget);
	gtk_main_quit();

	return FALSE;
}


gboolean
on_app1_delete_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gui_full_save(widget,NULL);
	gtk_widget_destroy(widget);
	gtk_main_quit();

  return FALSE;
}


void
on_ul_graph_by_weekday_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_ul_type=GRAPH_BY_WEEKDAY;
	build_graph_image(-1,-1);

	if(graph_ul_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"ul_graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_ul_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


void
on_ul_graph_by_monthday_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_ul_type=GRAPH_BY_MONTHDAY;
	build_graph_image(-1,-1);

	if(graph_ul_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"ul_graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_ul_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


void
on_on_ul_display_by_transfer_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_ul_display_type=GRAPH_BY_TRANSFER;
	build_graph_image(-1,-1);

	if(graph_ul_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"ul_graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_ul_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


void
on_on_ul_display_by_size_radiobutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	graph_ul_display_type=GRAPH_BY_SIZE;
	build_graph_image(-1,-1);

	if(graph_ul_image!=NULL)
	{
		widget=get_widget_by_widget_name(main_window,"ul_graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_ul_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


void
on_ul_redraw_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	/* reload the list in memory, update the displayed list and update the graphic */
	load_all_done_lists();

	/* create the new graphic */
	build_graph_image(-1,-1);

	/* and display it */
	if(graph_ul_image!=NULL)
	{
		GtkWidget *widget;

		widget=get_widget_by_widget_name(main_window,"ul_graph_drawingarea");
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_ul_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
}


gboolean
on_ul_graph_drawingarea_expose_event   (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	if((graph_ul_image==NULL)||(graph_image_w!=widget->allocation.width)||(graph_image_h!=widget->allocation.height))
	{
		if(graph_depth==-1)
		{
	   	graph_depth=gdk_drawable_get_depth(widget->window);
		}
		build_graph_image(widget->allocation.width, widget->allocation.height);
	}

	if(graph_ul_image!=NULL)
	{
		gdk_draw_drawable(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							graph_ul_image,
							0, 0,
							0, 0, widget->allocation.width, widget->allocation.height);
	}
	return FALSE;
}

