CREATE SEQUENCE "seq_accounts";
CREATE SEQUENCE "seq_attributesets";
CREATE SEQUENCE "seq_views";
CREATE SEQUENCE "seq_tickets";
CREATE SEQUENCE "seq_ticketresolutions";
CREATE SEQUENCE "seq_faq";
CREATE SEQUENCE "seq_faqtopics";
CREATE SEQUENCE "seq_faqquestions";
CREATE SEQUENCE "seq_faqanswers";
CREATE SEQUENCE "seq_timecards";
CREATE SEQUENCE "seq_severity";
CREATE SEQUENCE "seq_departments";
CREATE SEQUENCE "seq_jcn";
CREATE SEQUENCE "seq_projects";
CREATE SEQUENCE "seq_watches";

CREATE SEQUENCE 
	"seq_personnel" 
	start 2 increment 1 maxvalue 2147483647 minvalue 1  cache 1 ;
SELECT nextval ('seq_personnel');


CREATE SEQUENCE 
	"seq_actions" 
	start 7 increment 1 maxvalue 2147483647 minvalue 1  cache 1 ;
SELECT nextval ('seq_actions');

CREATE SEQUENCE "seq_priorities";
CREATE SEQUENCE "seq_products";

CREATE SEQUENCE 
	"seq_statuses" 
	start 4 increment 1 maxvalue 2147483647 minvalue 1  cache 1 ;
SELECT nextval ('seq_statuses');

CREATE TABLE "personnel" (
		"id" "int4" NOT NULL,
		"short" char(10) NOT NULL, 
		"lastname" varchar(25), 
		"firstname" varchar(20), 
		"reportto" "int4", 
		"department" "int4", 
		"pwd" varchar(50), 
		"security" "int4", 
		"email" varchar(80),
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "accounts" (
		"id" "int4" NOT NULL, 
		"short" char(10) NOT NULL, 
		"name" varchar(30) NOT NULL, 
		"add1" varchar(30), 
		"add2" varchar(30), 
		"city" varchar(50), 
		"state" char(2), 
		"zip" char(11), 
		"contact" varchar(50), 
		"voice" char(10), 
		"fax" char(10), 
		"data1" char(10), 
		"data2" char(10), 
		"notes" varchar(1024),
		"active" varchar(1) default 'Y'
	);

create unique index "uc_accounts_short" on accounts("short");
create unique index "uc_accounts_name" on accounts("name");


CREATE TABLE "actions" (
		"id" "int4" NOT NULL, 
		"short" char(10) NOT NULL, 
		"name" varchar(20) NOT NULL,
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "priorities" (
		"id" "int4" NOT NULL, 
		"short" char(10) NOT NULL, 
		"name" varchar(20) NOT NULL, 
		"weight" "int4" NOT NULL,
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "products" (
		"id" "int4" NOT NULL, 
		"short" char(10) NOT NULL, 
		"name" varchar(50) NOT NULL, 
		"reportto" "int4",
		"active" varchar(1) default 'Y',
		"ticketsto" "int4" NOT NULL,
		"wosetid" "int4" NOT NULL,
		"tcksetid" "int4" NOT NULL
	);

CREATE TABLE "statuses" (
		"id" "int4" NOT NULL, 
		"short" char(10) NOT NULL, 
		"name" varchar(20) NOT NULL,
		"active" varchar(1) default 'Y',
		"dcl_status_type" "int4" default '1' not null
	);

CREATE TABLE "timecards" (
		"id" "int4" NOT NULL, 
		"jcn" "int4" NOT NULL, 
		"seq" "int4" NOT NULL, 
		"actionon" "date" NOT NULL, 
		"inputon" "timestamp" DEFAULT now() NOT NULL, 
		"actionby" "int4" NOT NULL, 
		"status" "int4" NOT NULL, 
		"action" "int4" NOT NULL, 
		"hours" "float8" NOT NULL, 
		"summary" varchar(100) NOT NULL, 
		"description" varchar(1024), 
		"revision" varchar(20),
		"reassign_from_id" "int4" null,
		"reassign_to_id" "int4" null
	);

CREATE TABLE "severities" (
		"id" "int4" NOT NULL, 
		"short" char(10) NOT NULL, 
		"name" varchar(20) NOT NULL, 
		"weight" "int4" NOT NULL,
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "departments" (
		"id" "int4" NOT NULL,
		"short" char(10) NOT NULL, 
		"name" varchar(30) NOT NULL,
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "workorders" (
		"jcn" "int4" NOT NULL,
		"seq" "int4" NOT NULL,
		"product" "int4" NOT NULL,
		"createby" "int4" NOT NULL,
		"createdon" "timestamp" NOT NULL,
		"closedby" "int4",
		"closedon" "date",
		"status" "int4" NOT NULL,
		"statuson" "timestamp" NOT NULL,
		"lastactionon" "timestamp",
		"deadlineon" "date",
		"eststarton" "date",
		"estendon" "date",
		"starton" "date",
		"esthours" "float8",
		"totalhours" "float8",
		"priority" "int4" NOT NULL,
		"severity" "int4" NOT NULL,
		"contact" varchar(50),
		"contactphone" char(10),
		"summary" varchar(100) NOT NULL,
		"notes" varchar(1024),
		"description" varchar(1024) NOT NULL,
		"responsible" "int4",
		"revision" varchar(20),
		"publicview" "bool",
		"etchours" "float8",
		"module_id" "int4",
		"wo_type_id" "int4",
		primary key(jcn, seq)
	);

create table "dcl_projects" (
		"projectid" "int4" not null primary key, 
		"name" varchar(100), 
		"reportto" "int4" not null, 
		"createdby" "int4" not null, 
		"createdon" "timestamp" not null default now(), 
		"projectdeadline" "date", 
		"description" varchar(1024) not null, 
		"status" "int4" not null, 
		"lastactivity" "timestamp", 
		"finalclose" "date",
		"parentprojectid" int4 default('0') not null
	);

create unique index "projects_name_key" on dcl_projects("name");

create table "projectmap" (
		"projectid" "int4" not null, 
		"jcn" "int4" not null, 
		"seq" "int4" not null, 
		primary key("projectid", "jcn", "seq")
	);

create table "watches" (
		"watchid" "int4" primary key not null,
		"typeid" "int4" not null,
		"whatid1" "int4" not null,
		"whatid2" "int4" not null,
		"whoid" "int4" not null,
		"actions" "int4" not null
	);

CREATE FUNCTION 
	"next_seq" ("int4" ) 
	RETURNS "int4" AS 
	'SELECT MAX(seq)+1 FROM WORKORDERS WHERE jcn = $1' LANGUAGE 'SQL';

COPY "personnel" FROM stdin;
1	sa        	Administrator		0	0	c12e01f2a13ff5587e1e9e4aedb8242d	9		Y
\.
COPY "actions" FROM stdin;
1	DBG       	Debug	Y
2	RES       	Research	Y
3	DOC       	Document	Y
4	TST       	Testing	Y
5	DES       	Design	Y
6	IMP       	Implementation	Y
7	CORR      	Correction	Y
\.
COPY "statuses" FROM stdin;
1	OP        	Open	Y	1
2	CL        	Closed	Y	2
3	DF        	Deferred	Y	3
4	UA        	Unassigned	Y	1
\.

CREATE UNIQUE INDEX 
	"personnel_pkey" 
	on "personnel" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"personnel_short_key" 
	on "personnel" using btree ( "short" "bpchar_ops" );

CREATE UNIQUE INDEX 
	"accounts_pkey" 
	on "accounts" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"actions_pkey" 
	on "actions" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"priorities_pkey" 
	on "priorities" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"products_pkey" 
	on "products" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"statuses_pkey" 
	on "statuses" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"timecards_pkey" 
	on "timecards" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"severities_pkey" 
	on "severities" using btree ( "id" "int4_ops" );

CREATE UNIQUE INDEX 
	"departments_pkey" 
	on "departments" using btree ( "id" "int4_ops" );

CREATE TABLE "tickets" (
		"ticketid" int4 NOT NULL,
		"product" int4 NOT NULL,
		"account" int4,
		"createdby" int4 NOT NULL,
		"createdon" timestamp DEFAULT 'now()' NOT NULL,
		"responsible" int4 NOT NULL,
		"closedby" int4,
		"closedon" timestamp,
		"status" int4 NOT NULL,
		"statuson" timestamp NOT NULL,
		"lastactionon" timestamp,
		"priority" int4 NOT NULL,
		"type" int4 NOT NULL,
		"contact" varchar(80),
		"contactphone" varchar(20),
		"issue" text NOT NULL,
		"version" varchar(20),
		"summary" varchar(100),
		"seconds" int4 not null default '0',
		"contactemail" varchar(100),
		"module_id" int4,
		PRIMARY KEY ("ticketid")
	);

CREATE TABLE "ticketresolutions" (
		"resid" int4 NOT NULL,
		"ticketid" int4 NOT NULL,
		"loggedby" int4 NOT NULL,
		"loggedon" timestamp DEFAULT 'now()' NOT NULL,
		"status" int4 NOT NULL,
		"resolution" text NOT NULL,
		"startedon" timestamp NOT NULL,
		PRIMARY KEY ("resid")
	);

CREATE TABLE "faq" (
		"faqid" int4 NOT NULL,
		"name" varchar(80) NOT NULL,
		"createby" int4,
		"createon" timestamp DEFAULT 'now()' NOT NULL,
		"modifyby" int4,
		"modifyon" timestamp,
		"active" char(1) DEFAULT 'Y' NOT NULL,
		"description" text,
		PRIMARY KEY ("faqid")
	);

CREATE TABLE "faqtopics" (
		"topicid" int4 NOT NULL,
		"seq" int4 NOT NULL,
		"faqid" int4 NOT NULL,
		"name" varchar(80) NOT NULL,
		"description" text NOT NULL,
		"createby" int4,
		"createon" timestamp DEFAULT 'now()' NOT NULL,
		"modifyby" int4,
		"modifyon" timestamp,
		"active" char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY ("topicid")
	);

CREATE TABLE "faqquestions" (
		"questionid" int4 NOT NULL,
		"seq" int4 NOT NULL,
		"topicid" int4 NOT NULL,
		"questiontext" text NOT NULL,
		"createby" int4,
		"createon" timestamp DEFAULT 'now()' NOT NULL,
		"modifyby" int4,
		"modifyon" timestamp,
		"active" char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY ("questionid")
	);

CREATE TABLE "faqanswers" (
		"answerid" int4 NOT NULL,
		"questionid" int4 NOT NULL,
		"answertext" text NOT NULL,
		"createby" int4 NOT NULL,
		"createon" timestamp DEFAULT 'now()' NOT NULL,
		"modifyby" int4,
		"modifyon" timestamp,
		"active" char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY ("answerid")
	);

CREATE TABLE "views" (
		"viewid" int4 NOT NULL,
		"whoid" int4 NOT NULL,
		"name" varchar(100) NOT NULL,
		"ispublic" char(1) DEFAULT 'N' NOT NULL,
		"viewurl" text NOT NULL,
		"tablename" varchar(30) not null,
		PRIMARY KEY("viewid")
	);


CREATE TABLE "attributesets" (
		"id" int4 NOT NULL,
		"short" varchar(20) NOT NULL,
		"name" varchar(100) NOT NULL,
		"active" char(1) NOT NULL DEFAULT 'Y'
	);

INSERT INTO attributesets(id,short,name,active) VALUES (nextval('seq_attributesets'), 'WO', 'Work Orders', 'Y');
INSERT INTO attributesets(id,short,name,active) VALUES (nextval('seq_attributesets'), 'TCK', 'Tickets', 'Y');

CREATE TABLE "attributesetsmap" (
		"setid" int4 NOT NULL,
		"typeid" int4 NOT NULL,
		"keyid" int4 NOT NULL,
		"weight" int4 NOT NULL
	);

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses;

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses;

CREATE TABLE "dcl_config" (
		"dcl_config_name" varchar(50) NOT NULL,
		"dcl_config_field" varchar(30) NOT NULL,
		"dcl_config_int" int4,
		"dcl_config_double" float8,
		"dcl_config_date" date,
		"dcl_config_datetime" timestamp,
		"dcl_config_varchar" varchar(255),
		PRIMARY KEY ("dcl_config_name")
	);

INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_ADD_USER', 'dcl_config_int', 9);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_ADD_WO', 'dcl_config_int', 3);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_ASSIGN_WO', 'dcl_config_int', 5);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_AUTO_DATE', 'dcl_config_varchar', 'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_CHG_PWD', 'dcl_config_int', 2);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_COLOR_DARK', 'dcl_config_varchar', '#000065');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_COLOR_LIGHT', 'dcl_config_varchar', '#eeeef8');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_CQQ_PERCENT', 'dcl_config_int', 0);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_CQQ_FROM', 'dcl_config_varchar', 'Somebody <someone@somewhere.org>');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_CQQ_SUBJECT', 'dcl_config_varchar', 'Thank You For Calling');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_CQQ_TEMPLATE', 'dcl_config_varchar', 'cqqmail.tpl');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT', 'dcl_config_varchar', 'm/d/Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT_DB', 'dcl_config_varchar', 'Y-m-d');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DEFAULT_LANGUAGE', 'dcl_config_varchar', 'en');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_PROJECT_STATUS', 'dcl_config_int', 1);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_TICKET_STATUS', 'dcl_config_int', 1);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_PRIORITY', 'dcl_config_int', 1);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_SEVERITY', 'dcl_config_int', 2);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_STATUS_ASSIGN_WO', 'dcl_config_int', 1);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_STATUS_UNASSIGN_WO', 'dcl_config_int', 4);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DEF_TEMPLATE_SET', 'dcl_config_varchar', 'default');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEL_WO', 'dcl_config_int', 8);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_FILE_PATH', 'dcl_config_varchar', '.');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_ACCOUNT', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPOND', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_FILE_PATH', 'dcl_config_varchar', '/tmp');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_PRIORITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_REPLY', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_REPLY_LOGGED_BY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_SEVERITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_STATUS', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPOND', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_FILE_PATH', 'dcl_config_varchar', '/tmp');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_PRIORITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_REPLY', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_SEVERITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_STATUS', 'dcl_config_int', 0);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_GD_TYPE', 'dcl_config_varchar', 'png');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_HAVE_WO', 'dcl_config_int', 4);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_HTML_TITLE', 'dcl_config_varchar', 'Double Choco Latte - Copyright (C) 1998-2001 Michael L. Dean and Tim R. Norman');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_MAX_UPLOAD_FILE_SIZE', 'dcl_config_int', 1048576);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_MOD_WO', 'dcl_config_int', 7);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PRIVATE_KEY', 'dcl_config_varchar', 'IloveDCL');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_BROWSE_PARENTS_ONLY', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_CHILD_STATS', 'dcl_config_varchar', 'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_PARENT_STATS', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_XML_TEMPLATES', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_ROOT', 'dcl_config_varchar', 'http://localhost/dcl/');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_SMTP_DEFAULT_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_SMTP_ENABLED', 'dcl_config_varchar', 'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_SMTP_PORT', 'dcl_config_int', 25);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_SMTP_SERVER', 'dcl_config_varchar', 'localhost');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_SMTP_TIMEOUT', 'dcl_config_int', 30);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_tck_en.tpl');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_NOTIFICATION_HTML', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_TIME_CARD_ORDER', 'dcl_config_varchar', 'ASC');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT', 'dcl_config_varchar', 'm/d/Y H:i:s');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT_DB', 'dcl_config_varchar', 'Y-m-d H:i:s');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_VERSION', 'dcl_config_varchar', '0.9.3');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_wo_en.tpl');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_NOTIFICATION_HTML', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_SECONDARY_ACCOUNTS_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_datetime) values ('LAST_CONFIG_UPDATE', 'dcl_config_datetime', now());
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_SESSION_TIMEOUT', 'dcl_config_int', 20);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WIKI_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_VIEW', 'dcl_config_int', 4);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_EDIT', 'dcl_config_int', 5);

CREATE SEQUENCE "seq_dcl_chklst";
CREATE TABLE "dcl_chklst" (
		"dcl_chklst_id" int4 DEFAULT nextval('seq_dcl_chklst') NOT NULL,
		"dcl_chklst_tpl_id" int4 NOT NULL,
		"dcl_chklst_summary" varchar(255) NOT NULL,
		"dcl_chklst_createby" int4 NOT NULL,
		"dcl_chklst_createon" timestamp DEFAULT 'now()' NOT NULL,
		"dcl_chklst_modifyby" int4,
		"dcl_chklst_modifyon" timestamp,
		"dcl_chklst_status" varchar(255),
		PRIMARY KEY ("dcl_chklst_id")
	);

CREATE SEQUENCE "seq_dcl_chklst_tpl";
CREATE TABLE "dcl_chklst_tpl" (
		"dcl_chklst_tpl_id" int4 DEFAULT nextval('seq_dcl_chklst_tpl') NOT NULL,
		"dcl_chklst_tpl_name" varchar(255) NOT NULL,
		"dcl_chklst_tpl_active" char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY ("dcl_chklst_tpl_id")
	);

Create Sequence "seq_dcl_product_module";
Create Table "dcl_product_module" (
		"product_module_id" int4 Default nextval('seq_dcl_product_module') Not Null,
		"product_id" int4 Not Null,
		"module_name" varchar(50) Not Null,
		"active" char(1) Not Null,
		PRIMARY KEY ("product_module_id")
	);

Create Table dcl_wo_account (
	wo_id int4 not null,
	seq int4 not null,
	account_id int4 not null,
	primary key(wo_id, seq, account_id)
);


Alter Table workorders Drop Column account;

Create Sequence seq_dcl_wo_type;

Create Table dcl_wo_type (
	wo_type_id int4 not null default nextval('seq_dcl_wo_type'),
	type_name varchar(50) not null,
	active char(1) not null,
	Primary Key(wo_type_id)
);

Create Table dcl_session (
	dcl_session_id varchar(32) not null primary key,
	personnel_id int4 not null,
	create_date timestamp not null,
	update_date timestamp not null,
	session_data text null
);

Create Table dcl_preferences (
	personnel_id int4 not null primary key,
	preferences_data text null
);

create table dcl_status_type (
		dcl_status_type_id int4 not null primary key,
		dcl_status_type_name varchar(50) not null
	);

insert into dcl_status_type values (1, 'Open');
insert into dcl_status_type values (2, 'Completed');
insert into dcl_status_type values (3, 'Deferred');

Create Table dcl_wiki (
	dcl_entity_type_id int4 not null,
	dcl_entity_id int4 not null,
	dcl_entity_id2 int4 not null,
	page_name varchar(255) not null,
	page_text text null,
	page_date timestamp null,
	page_ip varchar(255) null,
	primary key (dcl_entity_type_id, dcl_entity_id, dcl_entity_id2, page_name)
);
