/*!

\if MANPAGES
\page echoscu DICOM verification (C-ECHO) SCU
\else
\page echoscu echoscu: DICOM verification (C-ECHO) SCU
\endif

\section synopsis SYNOPSIS

\verbatim
echoscu [options] peer port
\endverbatim

\section description DESCRIPTION

The \b echoscu application implements a Service Class User (SCU) for the
Verification SOP Class.  It sends a DICOM C-ECHO message to a Service
Class Provider (SCP) and waits for a response.  The application can be
used to verify basic DICOM connectivity.

\section parameters PARAMETERS

\verbatim
peer  hostname of DICOM peer

port  tcp/ip port number of peer
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information
\endverbatim

\subsection network_options network options
\verbatim
application entity titles:

  -aet  --aetitle  aetitle: string
          set my calling AE title (default: ECHOSCU)

  -aec  --call  aetitle: string
          set called AE title of peer (default: ANY-SCP)

association negotiation debugging:

  -pts  --propose-ts  [n]umber: integer (1..28)
          propose n transfer syntaxes

  -ppc  --propose-pc  [n]umber: integer (1..128)
          propose n presentation contexts

other network options:

  -to   --timeout  [s]econds: integer (default: unlimited)
          timeout for connection requests

  -pdu  --max-pdu  [n]umber of bytes: integer [4096..131072]
          set max receive pdu to n bytes (default: 16384)

        --repeat  [n]umber: integer
          repeat n times

        --abort
          abort association instead of releasing it
\endverbatim

\subsection tls_options transport layer security (TLS) options
\verbatim
transport protocol stack options:

  -tls  --disable-tls
          use normal TCP/IP connection (default)

  +tls  --enable-tls  [p]rivate key file, [c]ertificate file: string
          use authenticated secure TLS connection

  +tla  --anonymous-tls
          use secure TLS connection without certificate

private key password options (only with --enable-tls):

  +ps   --std-passwd
          prompt user to type password on stdin (default)

  +pw   --use-passwd  [p]assword: string
          use specified password

  -pw   --null-passwd
          use empty string as password

key and certificate file format options:

  -pem  --pem-keys
          read keys and certificates as PEM file (default)

  -der  --der-keys
          read keys and certificates as DER file

certification authority options:
  +cf   --add-cert-file  [c]ertificate filename: string
          add certificate file to list of certificates

  +cd   --add-cert-dir  [c]ertificate directory: string
          add certificates in d to list of certificates

ciphersuite options:

  +cs   --cipher  [c]iphersuite name: string
          add ciphersuite to list of negotiated suites

  +dp   --dhparam  [f]ilename: string
          read DH parameters for DH/DSS ciphersuites

pseudo random generator options:

  +rs   --seed  [f]ilename: string
          seed random generator with contents of f

  +ws   --write-seed
          write back modified seed (only with --seed)

  +wf   --write-seed-file  [f]ilename: string (only with --seed)
          write modified seed to file f

peer authentication options:

  -rc   --require-peer-cert
          verify peer certificate, fail if absent (default)

  -vc   --verify-peer-cert
          verify peer certificate if present

  -ic   --ignore-peer-cert
          don't verify peer certificate
\endverbatim

\section notes NOTES

\subsection dicom_conformance DICOM Conformance

The \b echoscu application supports the following SOP Classes as an SCU:

\verbatim
VerificationSOPClass                1.2.840.10008.1.1
\endverbatim
\if MANPAGES
.fi
\endif

Unless the \e --propose-ts option is used, the echoscu application will only
propose the transfer syntax

\verbatim
LittleEndianImplicitTransferSyntax  1.2.840.10008.1.2
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b echoscu utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section copyright COPYRIGHT

Copyright (C) 1994-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/