/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * misc.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: misc.c,v 1.6 2004/01/09 18:16:01 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/param.h>
#include <errno.h>
#include <glib.h>

#include "misc.h"

/***********************************************************/
/* routine copiant par troncature une chaine de caracteres */
/***********************************************************/
void strncpy_max(char *destination, const char *source, int max_byte)
{
	strncpy(destination,source,max_byte-1);
	destination[max_byte-1]='\0';
}

/*****************************************************************/
/* empty the given array of allocated strings and free the array */
/*****************************************************************/
void wipe_GPtrArray_of_char_string(GPtrArray **array)
{
	char *s;

	if((*array)!=NULL)
	{
		while((*array)->len>0)
		{
			s=g_ptr_array_index((*array),0);
			if(s!=NULL)
				free(s);
			g_ptr_array_remove_index_fast((*array),0);
		}
		g_ptr_array_free((*array),TRUE);
		(*array)=NULL;
	}
}

/***********************************************************************/
/* search for a string in the array of strings. Output: TRUE if inside */
/***********************************************************************/
gboolean find_a_char_string_in_GPtrArray(GPtrArray **array, const char *str)
{
	gboolean ret=FALSE;
	int i;
	char *s;

	if((*array)!=NULL)
	{
		for(i=0;i<(*array)->len;i++)
		{
			s=g_ptr_array_index((*array),i);
			if(s)
			{
				if(!strcmp(s,str))
				{
					ret=TRUE;
					break;
				}
			}
		}
	}
	return ret;
}

/*************************************************************/
/* build any required directory from the given absolute path */
/*************************************************************/
static int recursive_build_directory(GString *dir)
{
	struct stat st;

	if(stat(dir->str,&st)==0)
	{
		return 0;
	}
	else
	{
		GString *new_dir;
		char *t;
		int ret;

		new_dir=g_string_new(dir->str);
		t=strrchr(new_dir->str,'/');
		if(t==NULL)
		{
			g_string_free(new_dir,TRUE);
			return ENOTDIR;
		}

		new_dir=g_string_truncate(new_dir,t-new_dir->str);
		ret=recursive_build_directory(new_dir);
		g_string_free(new_dir,TRUE);

		if(ret!=0)
			return ret;

		if(stat(dir->str,&st)==0)
		{	/* it can look stupid to check if the directory we want to create already exist */
			/* because we just have created its parent however, if the directory we want to create is "xxx/yyy/." */
			/* creating "xxx/yyy" has already created the "." directory. */
			return 0;
		}

		if(mkdir(dir->str,0777))
		{
			return errno;
		}
		return 0;
	}
}

/******************************************************/
/* create the given directory (it can start with a /) */
/******************************************************/
/* output: 0=ok else errno */
/***************************/
int recursive_mkdir(GString *directory_name)
{
	GString *final_name;
	int ret;

	if(directory_name->str[0]=='/')
		final_name=g_string_new(directory_name->str);
	else
	{
		char the_cwd[MAXPATHLEN];
		if(getcwd(the_cwd,sizeof(the_cwd)-1)==NULL)
		{
			return errno;
		}

		final_name=g_string_new(the_cwd); 
		if(final_name->str[final_name->len-1]!='/')
			final_name=g_string_append_c(final_name,'/'); 
		final_name=g_string_append(final_name,directory_name->str);
	}

	/* now, final_name is an absolute path */
	ret=recursive_build_directory(final_name);

	g_string_free(final_name,TRUE);

	return ret;
}

/******************************************************************************/
/* count the number of entry inside the given gchar * array (NULL terminated) */
/******************************************************************************/
int gchar_array_len(gchar **array)
{
	int nb=0;
	if (array==NULL)
		return 0;

	while(array[nb]!=NULL)
		nb++;

	return nb;
}

