/* dia-textbox.h
 * Copyright (C) 2001  Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 * DiaTextbox
 * ----------
 * A nice demonstration of a somewhat more complex object: a textbox.
 */

#ifndef __DIA_TEXTBOX_H__
#define __DIA_TEXTBOX_H__

#include <diacanvas/dia-canvas-element.h>

G_BEGIN_DECLS

#define DIA_TYPE_TEXTBOX		(dia_textbox_get_type ())
#define DIA_TEXTBOX(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), DIA_TYPE_TEXTBOX, DiaTextbox))
#define DIA_TEXTBOX_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), DIA_TYPE_TEXTBOX, DiaTextboxClass))
#define DIA_IS_TEXTBOX(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIA_TYPE_TEXTBOX))
#define DIA_IS_TEXTBOX_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), DIA_TYPE_TEXTBOX))
#define DIA_TEXTBOX_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), DIA_TYPE_TEXTBOX, DiaTextboxClass))

typedef struct _DiaTextbox DiaTextbox;
typedef struct _DiaTextboxClass DiaTextboxClass;

struct _DiaTextbox
{
	DiaCanvasElement item;

	DiaCanvasItem *text;
};


struct _DiaTextboxClass
{
	DiaCanvasElementClass parent_class;
};

GType dia_textbox_get_type (void);


G_END_DECLS


#endif /* __DIA_TEXTBOX_H__ */
