/* dia-shape_.c
 * Copyright (C) 2000  Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "unit-test.h"
#include "dia-shape.h"

static DiaShape *shape;

void
test_dia_shape_setup (void)
{
	shape = dia_shape_new ();
	TEST (shape != NULL);
	TEST (shape->any.type == DIA_SHAPE_NONE);
	TEST (shape->any.update_cnt == 0);
	TEST (shape->any.view_info == NULL);
}

void
test_dia_shape_teardown (void)
{
	dia_shape_free (shape);
}

/* TODO: All initialization functions should also work if shape == NULL.
 */


TEST_BEGIN ("DiaShape", test_dia_shape_setup, test_dia_shape_teardown)

NEW_TEST (dia_shape_request_update)
{
	/* add some entries to the GList... */
	shape->any.view_info = g_list_append (shape->any.view_info, NULL);
	TEST (g_list_length (shape->any.view_info) == 1);

	dia_shape_request_update (shape);
	TEST (shape->any.update_cnt == 1);

	shape->any.view_info = g_list_append (shape->any.view_info, NULL);
	TEST (g_list_length (shape->any.view_info) == 2);

	dia_shape_request_update (shape);
	TEST (shape->any.update_cnt == 2);

	g_list_free (shape->any.view_info);
	shape->any.view_info = NULL;
}

NEW_TEST (dia_shape_need_update)
{
	shape->any.update_cnt = 1;
	TEST (dia_shape_need_update (shape));
	shape->any.update_cnt = 0;
	TEST (!dia_shape_need_update (shape));
	
	// TODO - isn't there any way to break this one?
	
}

NEW_TEST (dia_shape_is_updated)
{
	TEST (shape->any.update_cnt == 0);
	dia_shape_is_updated (shape);
	TEST (shape->any.update_cnt == 0);

	shape->any.update_cnt = 1;
	dia_shape_is_updated (shape);
	TEST (shape->any.update_cnt == 0);
}

NEW_TEST (dia_shape_line)
{
	DiaShape *got = NULL;
	DiaPoint start = { 10, 10 }, end = { 20, 20 };

	TEST (shape->path.vpath == NULL);
	got = dia_shape_line (shape, &start, &end);
	TEST (got == shape);
	TEST (shape->path.vpath != NULL);
}

NEW_TEST (dia_shape_rectangle)
{
	DiaShape *got = NULL;
	DiaPoint upper_left = { 10, 10 }, lower_right = { 20, 20 };
	
	TEST (shape->path.vpath == NULL);
	got = dia_shape_rectangle (shape, &upper_left, &lower_right);
	TEST (got == shape);
	TEST (shape->path.vpath != NULL);
}


NEW_TEST (dia_shape_color)
{
	DiaShape * got = NULL;
	DiaShape * shape = dia_shape_new ();
	const DiaColor BLUE = DIA_COLOR (0, 0, 255);
	const DiaColor YELLOW = DIA_COLOR (255, 255, 0);

	got = dia_shape_color (shape, BLUE);
	TEST (got == shape);
	TEST (got->any.color == BLUE);

	got = dia_shape_color (NULL, YELLOW);
	TEST (got);
	TEST (got->any.color == YELLOW);

	dia_shape_free (got);
	// TODO - ibid

}

TEST_END ();

