/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002-2004 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#include <string.h>
#include <curl/curl.h>
#include <libgnomevfs/gnome-vfs-ops.h>

#include "utils.h"

static gboolean
return_true (gpointer key, gpointer value, gpointer data)
{
	return TRUE;
}

void
hash_table_item_free (gpointer data)
{
	g_free (data);
	data = NULL;
	
	return;
}

void
hash_table_clear (GHashTable *table)
{
	g_hash_table_foreach_remove (table, return_true, NULL);
	
	return;
}

gint
string_compare (gconstpointer a, gconstpointer b)
{
	gint retval;
	
	if (strlen (a) < strlen (b))
		retval = strncmp (a, b, strlen (b));
	else 
		retval = strncmp (a, b, strlen (a));

	return retval;
}

gchar*
unescape_text (const gchar *text)
{
	gchar *delimited, *unescaped;
	
	if (!text)
		return NULL;
	
	delimited = g_strdup (text);
	g_strdelimit (delimited, "+", ' ');
	unescaped = curl_unescape (delimited, 0);

	g_free (delimited);

	return unescaped;
}

GladeXML*
load_glade_xml (void)
{
	gchar *path;
	GladeXML *xml = NULL;
	
	if (g_file_test (DRIVEL_GLADE_FILE, G_FILE_TEST_EXISTS))
		xml = glade_xml_new (DRIVEL_GLADE_FILE, NULL, GETTEXT_PACKAGE);
	else
	{
		path = g_build_filename ("src", DRIVEL_GLADE_FILE, NULL);
		if (g_file_test (path, G_FILE_TEST_EXISTS))
			xml = glade_xml_new (path, NULL, GETTEXT_PACKAGE);
		else
		{
			g_free (path);
			path = g_build_filename (DRIVEL_GLADE_DIR, DRIVEL_GLADE_FILE, NULL);
			xml = glade_xml_new (path, NULL, GETTEXT_PACKAGE);
		}
		g_free (path);
	}
	
	return xml;
}

gboolean
picture_exists (const gchar *config_dir, const gchar *pic_file)
{
	gboolean exists;
	gchar *path;
	GnomeVFSFileInfo info;
	
	path = g_build_filename (config_dir, "pictures", pic_file, NULL);
	if (gnome_vfs_get_file_info (path, &info, GNOME_VFS_FILE_INFO_DEFAULT) == GNOME_VFS_OK)
		exists = TRUE;
	else
		exists = FALSE;
	
	g_free (path);
	
	return exists;
}
