/*  $Header: /cvsroot/dvipdfmx/src/pdfximage.h,v 1.1 2004/03/11 11:50:24 hirata Exp $
    
    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    Copyright (C) 1998, 1999 by Mark A. Wicks <mwicks@kettering.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

#ifndef _PDFXIMAGE_H_
#define _PDFXIMAGE_H_

#include "pdfspecial.h"
#include "pdfdev.h"

#define PDF_XOBJECT_TYPE_FORM  0
#define PDF_XOBJECT_TYPE_IMAGE 1

typedef struct {
  int  flags;

  long width;
  long height;

  int  bits_per_component;
  int  num_components;

  long min_dpi; /* NOT USED YET */
} ximage_info;

typedef struct {
  int         flags;
  
  pdf_rect    bbox;
  pdf_tmatrix matrix;
} xform_info;

typedef struct pdf_ximage pdf_ximage;

extern void pdf_ximage_set_verbose (void);
extern void pdf_ximage_init  (void);
extern void pdf_ximage_close (void);

extern int      pdf_ximage_get_form_info (int xobj_id, xform_info *form_info);

extern int      pdf_ximage_findresource   (const char *ident);
extern pdf_obj *pdf_ximage_getresource    (int xobj_id);
extern int      pdf_ximage_defineresource (const char *ident, int subtype,
					   void *info, pdf_obj *resource);

extern int  pdf_ximage_put_image (int xobj_id, transform_info *p, double ref_x, double ref_y);

/* Called by pngimage, jpegimage, epdf, mpost, etc. */
extern void pdf_ximage_init_image_info (ximage_info *info);
extern void pdf_ximage_init_form_info  (xform_info  *info);
extern void pdf_ximage_set_image (pdf_ximage *ximage, void *info, pdf_obj *resource);
extern void pdf_ximage_set_form  (pdf_ximage *ximage, void *info, pdf_obj *resource);


#endif /* _PDFXIMAGE_H_ */
