/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef __TNode_hh__
#define __TNode_hh__

#include "dom.hh"
#include "globals.hh"
#include "TDictionary.hh"

class TNode
{
public:
  TNode(void) : node(0) { };
  TNode(const DOM::Node& n) : node(n) { };
  TNode(const DOM::Element& elem) : node(elem) { };
  TNode(const TNode& n) : node(n.node) { };

  TNode next(void) const;
  TNode nextL(void) const;
  TNode prev(void) const;
  TNode prevL(void) const;
  TNode core(void) const;
  TNode parent(void) const;
  TNode first(void) const;
  TNode firstL(void) const;
  TNode last(void) const;
  TNode lastL(void) const;
  TNode child(unsigned) const;
  unsigned size(void) const;
  bool  empty(void) const { return !first().node; };
  std::string value(void) const { return (*this)["val"]; };

  class ProxyAttr
  {
  public:
    ProxyAttr(const DOM::Element& n, const std::string& s) : node(n), name(s) { };
    operator std::string() const { return node.getAttribute(name); };
    ProxyAttr& operator=(const std::string& v) { node.setAttribute(name, v); };
    bool       operator==(const std::string& v) const { return node.getAttribute(name) == v; };
    bool       operator!=(const std::string& v) const { return node.getAttribute(name) != v; };
  private:
    DOM::Element node;
    std::string  name;
  };

  operator bool() const { return node; };
  DOM::Element element(void) const { return node; };
  bool operator==(const TNode& n) const { return node == n.node; };
  bool operator!=(const TNode& n) const { return node != n.node; };
  TNode operator[](int i) const { return child(i); };
  ProxyAttr operator[](const char* s) const { return ProxyAttr(node, s); };

  //void  advance(const TNode&) const;
  void  remove(void) const;
  void  replace(const TNode&) const;
  void  replace(const TNode&, const TNode&) const;
  void  insert(const TNode&) const;
  void  append(const TNode&) const;
  void  append(const TNode&, const TNode&) const;
  void  prepend(const TNode&) const;

  std::string get(const std::string&) const;
  void  set(const std::string&, const std::string&) const;

  std::string name(void) const { return node.get_localName(); };
  std::string nameC(void) const { return node.getAttribute("name"); };
  bool  hasId(void) const { return node.hasAttribute("id"); };
  bool  hasId(const std::string& id) const { return node.getAttribute("id") == id; };
  bool  is(const std::string& s) const { return name() == s; };
  bool  isG(void) const { return is("g"); };
  bool  isSb(void) const { return is("sb"); };
  bool  isSp(void) const { return is("sp"); };
  bool  isC(void) const { return is("c"); }
  bool  isC(const std::string& name) const
  { return isC() && node.getAttribute("name") == name; };
  bool  isT(void) const { return (is("o") || is("i") || is("n") || is("s")); };

  friend class TDocument;

private:
  DOM::Element node;
};

#endif // __TNode_hh__
