#ifndef NORESTORE
#include "obsave.h"
#endif
#include "pdl_gen.h"

#ifdef MONITOR
#include "pdl_dapto.h"
#endif

#define PRESENT find(key, _property, (Entry *)&_Item, 0)
#define VALUE (_Item->PropVal)

#define TYPE int

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct intElt))

typedef struct intElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *intProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
Getint (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
Getint (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  intProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
Setint (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
Setint (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  intProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
Resetint (int _property, DefTableKey key, TYPE _val)
#else
void
Resetint (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  intProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#if defined(__STDC__) || defined(__cplusplus)
TYPE
SetGetint (int _property, DefTableKey key, TYPE init, TYPE reset)
#else
TYPE
SetGetint (_property, key, init, reset)
int _property;
DefTableKey key;
TYPE init;
TYPE reset;
#endif
{  intProperty _Item;
{ if (key == NoKey) return init;
  if (ACCESS)   {VALUE = reset; return reset;}
  else          {VALUE = init; return init;}
}
}

#undef ACCESS
#undef TYPE
#define TYPE ProdElemList

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct ProdElemListElt))

typedef struct ProdElemListElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *ProdElemListProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetProdElemList (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetProdElemList (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  ProdElemListProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetProdElemList (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetProdElemList (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  ProdElemListProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetProdElemList (int _property, DefTableKey key, TYPE _val)
#else
void
ResetProdElemList (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  ProdElemListProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE DefTableKey

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct DefTableKeyElt))

typedef struct DefTableKeyElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *DefTableKeyProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetDefTableKey (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetDefTableKey (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  DefTableKeyProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetDefTableKey (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetDefTableKey (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  DefTableKeyProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetDefTableKey (int _property, DefTableKey key, TYPE _val)
#else
void
ResetDefTableKey (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  DefTableKeyProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE CoordRef

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct CoordRefElt))

typedef struct CoordRefElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *CoordRefProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetCoordRef (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetCoordRef (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  CoordRefProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetCoordRef (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetCoordRef (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  CoordRefProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetCoordRef (int _property, DefTableKey key, TYPE _val)
#else
void
ResetCoordRef (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  CoordRefProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE IntSet

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct IntSetElt))

typedef struct IntSetElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *IntSetProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetIntSet (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetIntSet (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  IntSetProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetIntSet (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetIntSet (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  IntSetProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetIntSet (int _property, DefTableKey key, TYPE _val)
#else
void
ResetIntSet (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  IntSetProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#if defined(__STDC__) || defined(__cplusplus)
TYPE
InsertIntSet (int _property, DefTableKey key, int val)
#else
TYPE
InsertIntSet (_property, key, val)
int _property;
DefTableKey key;
int val;
#endif
{  IntSetProperty _Item;
{ if (key == NoKey) return NULLIS;
  if (val < 0 || val > 8*sizeof(TYPE))
     message(DEADLY,"Invalid set element",0,NoPosition);
  if (!ACCESS) VALUE = NULLIS;
  VALUE |= (1<<val);
  return VALUE;
}
}

#if defined(__STDC__) || defined(__cplusplus)
TYPE
UnionIntSet (int _property, DefTableKey key, TYPE val)
#else
TYPE
UnionIntSet (_property, key, val)
int _property;
DefTableKey key;
TYPE val;
#endif
{  IntSetProperty _Item;
{ if (key == NoKey) return NULLIS;
  if (!ACCESS) VALUE = val;
  else VALUE |= val;
  return VALUE;
}
}

#if defined(__STDC__) || defined(__cplusplus)
TYPE
IntersectIntSet (int _property, DefTableKey key, TYPE val)
#else
TYPE
IntersectIntSet (_property, key, val)
int _property;
DefTableKey key;
TYPE val;
#endif
{  IntSetProperty _Item;
{ if (key == NoKey) return NULLIS;
  if (!ACCESS) VALUE = val;
  else VALUE &= val;
  return VALUE;
}
}

#undef ACCESS
#undef TYPE

static struct PdlGenState
{
	struct PropElt PDLe0;
} state = {
	{(Entry)0, 0}
};

#ifndef NORESTORE

void *SaveModulePdlgen()
{
	return (void *)0;
}

void
#if defined(__cplusplus) || defined(__STDC__) 
RestoreModulePdlgen(void *base)
#else
RestoreModulePdlgen(base) void *base;
#endif
{
}

#endif

DefTableKey
#if defined(__STDC__) || defined(__cplusplus)
CloneKey (DefTableKey key)
#else
CloneKey (key)
    DefTableKey key;
#endif
{
  DefTableKey k;
  Entry e;

  if (key == NoKey) return NoKey;
  k = NewKey ();
  for (e = key->List; (e != (Entry)0) && (e->selector != 0);
       e = e->next) {
    switch (e->selector) {
      case 1:
         ResetClpValue (k, ((intProperty)e)->PropVal);
         break;
      case 2:
         ResetProd (k, ((ProdElemListProperty)e)->PropVal);
         break;
      case 3:
         ResetDiffProd (k, ((intProperty)e)->PropVal);
         break;
      case 4:
         ResetLhsProd (k, ((DefTableKeyProperty)e)->PropVal);
         break;
      case 5:
         ResetErrLhsProd (k, ((intProperty)e)->PropVal);
         break;
      case 6:
         ResetCoord (k, ((CoordRefProperty)e)->PropVal);
         break;
      case 7:
         ResetSym (k, ((intProperty)e)->PropVal);
         break;
      case 8:
         ResetNextRule (k, ((DefTableKeyProperty)e)->PropVal);
         break;
      case 9:
         ResetKindSet (k, ((IntSetProperty)e)->PropVal);
         break;
      case 10:
         ResetPrdKindSet (k, ((IntSetProperty)e)->PropVal);
         break;
      case 11:
         ResetFirstOcc (k, ((intProperty)e)->PropVal);
         break;
      }
  }
  return k;
}

#ifdef MONITOR
static char *pdl_names[] = {
    (char *)0,
    "ClpValue",
    "Prod",
    "DiffProd",
    "LhsProd",
    "ErrLhsProd",
    "Coord",
    "Sym",
    "NextRule",
    "KindSet",
    "PrdKindSet",
    "FirstOcc",
};
static char *pdl_types[] = {
    (char *)0,
    "int",
    "ProdElemList",
    "int",
    "DefTableKey",
    "int",
    "CoordRef",
    "int",
    "DefTableKey",
    "IntSet",
    "IntSet",
    "int",
};

void
#if defined(__STDC__) || defined(__cplusplus)
pdl_mon_properties(DefTableKey k)
#else
pdl_mon_properties(k) DefTableKey k;
#endif
{
    Entry e;
    if (k == NoKey) return;
    for (e = k->List; (e != (Entry)0) && (e->selector != 0);
         e = e->next) {
        DAPTO_RESULT_STR (pdl_names[e->selector]);
        DAPTO_RESULT_STR (pdl_types[e->selector]);
        switch (e->selector) {
            case 1:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 2:
#ifdef DAPTO_RESULTProdElemList
                DAPTO_RESULTProdElemList (((ProdElemListProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((ProdElemListProperty)e)->PropVal);
#endif
                break;
            case 3:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 4:
#ifdef DAPTO_RESULTDefTableKey
                DAPTO_RESULTDefTableKey (((DefTableKeyProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((DefTableKeyProperty)e)->PropVal);
#endif
                break;
            case 5:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 6:
#ifdef DAPTO_RESULTCoordRef
                DAPTO_RESULTCoordRef (((CoordRefProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((CoordRefProperty)e)->PropVal);
#endif
                break;
            case 7:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 8:
#ifdef DAPTO_RESULTDefTableKey
                DAPTO_RESULTDefTableKey (((DefTableKeyProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((DefTableKeyProperty)e)->PropVal);
#endif
                break;
            case 9:
#ifdef DAPTO_RESULTIntSet
                DAPTO_RESULTIntSet (((IntSetProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((IntSetProperty)e)->PropVal);
#endif
                break;
            case 10:
#ifdef DAPTO_RESULTIntSet
                DAPTO_RESULTIntSet (((IntSetProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((IntSetProperty)e)->PropVal);
#endif
                break;
            case 11:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            default: DAPTO_RESULT_STR ("unknown property");
        }
    }
}
#endif
