

#include "PTGNodeList.h"
#include "err.h"
#include "obstack.h"

typedef struct {
  Obstack space;
  void *baseptr;
} Dyn, *DynP;

static DynP PTGNodeListSpace = (DynP)0;

#if defined(__STDC__) || defined(__cplusplus)
void FinlPTGNodeList (void)
#else
void FinlPTGNodeList ()
#endif
{
    if (PTGNodeListSpace != (DynP)0)
    {  obstack_free(&(PTGNodeListSpace->space), PTGNodeListSpace->baseptr);
       PTGNodeListSpace->baseptr = obstack_alloc(&(PTGNodeListSpace->space), 0);
    }
}/* FinlPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList ConsPTGNodeList (PTGNode e, PTGNodeList l)
#else
PTGNodeList ConsPTGNodeList (e, l)
        PTGNode e;
        PTGNodeList     l;
#endif
{
    PTGNodeList h;

    if (PTGNodeListSpace == (DynP)0)
    {   PTGNodeListSpace = (DynP) malloc (sizeof(Dyn));
        if (PTGNodeListSpace == (DynP)0)
        {  message (DEADLY, "no space for PTGNodeList", 0, (POSITION*)0);
           exit (1);
        }
        obstack_init(&(PTGNodeListSpace->space));
        PTGNodeListSpace->baseptr =
                obstack_alloc(&(PTGNodeListSpace->space), 0);
    }

    h = (PTGNodeList)obstack_alloc(&(PTGNodeListSpace->space),
                                  sizeof (struct _PTGNodeLE));
    h->head = e;
    h->tail= l;
    return (h);
}/* ConsPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNode HeadPTGNodeList (PTGNodeList l)
#else
PTGNode HeadPTGNodeList (l)
        PTGNodeList     l;
#endif
{
    if (l == NULLPTGNodeList)
    {
        message (DEADLY, "HeadPTGNodeList: empty list", 0, (POSITION*)0);
        /* return ((PTGNode)0); */
    } /* if */
    return (l->head);
}/* HeadPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList TailPTGNodeList (PTGNodeList l)
#else
PTGNodeList TailPTGNodeList (l)
        PTGNodeList     l;
#endif
{
    return ((l==NULLPTGNodeList) ? NULLPTGNodeList : l->tail);
}/* TailPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
int LengthPTGNodeList (PTGNodeList l)
#else
int LengthPTGNodeList (l)
        PTGNodeList     l;
#endif
{
    int res = 0;

    for (; l; l = l->tail)
        res++;
    return (res);
}/* LengthPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNode IthElemPTGNodeList (PTGNodeList l, int i)
#else
PTGNode IthElemPTGNodeList (l, i)
        PTGNodeList     l;
        int     i;
#endif
{
    while ((i>1) && l)
    {
        i--;
        l = l->tail;
    }

    if ((i<=0) || (l==NULLPTGNodeList))
        message (DEADLY, "IthElemPTGNodeList: no such element",
                 0, (POSITION*)0);
    return (l->head);
}/* IthPTGNodeList */


#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList CopyPTGNodeList (PTGNodeList l, PTGNodeMapFct cp)
#else
PTGNodeList CopyPTGNodeList (l, cp)
        PTGNodeList l;
        PTGNodeMapFct   cp;
#endif
{
    PTGNodeList NewList=NULLPTGNodeList, *addr = &NewList;

    while (l)
    {
        (*addr) = ConsPTGNodeList (cp (l->head), NULLPTGNodeList);
        addr = &((*addr)->tail);
        l = l->tail;
    }
    return (NewList);
}/* CopyPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList AppPTGNodeList (PTGNodeList l1, PTGNodeList l2)
#else
PTGNodeList AppPTGNodeList (l1, l2)
        PTGNodeList     l1, l2;
#endif
{
    PTGNodeList NewList;
    PTGNodeList *addr = &NewList;

    if (!l1) return (l2);
    if (!l2) return (l1);

    while (l1) {
        (*addr) = ConsPTGNodeList (l1->head, NULLPTGNodeList);
        addr = &((*addr)->tail);
        l1 = l1->tail;
    }
    (*addr) = l2;

    return (NewList);
}/* AppPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList AppElPTGNodeList (PTGNodeList l, PTGNode e)
#else
PTGNodeList AppElPTGNodeList (l, e)
        PTGNodeList     l;
        PTGNode e;
#endif
{
    PTGNodeList res = l;
    if (!l)
        return (ConsPTGNodeList (e, NULLPTGNodeList));

    while (l->tail)
        l = l->tail;
    l->tail = ConsPTGNodeList (e, NULLPTGNodeList);

    return (res);
} /* AppElPTGNodeList */


#if defined(__STDC__) || defined(__cplusplus)
void InsertAfterPTGNodeList (PTGNodeList l, PTGNode e)
#else
void InsertAfterPTGNodeList (l, e)
        PTGNodeList     l;
        PTGNode e;
#endif
{
    if (!l)
        message (DEADLY, "InserAfterPTGNodeList: null list", 0, (POSITION*)0);
    else
        l->tail = ConsPTGNodeList (e, l->tail);
}/* InsertAfterPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList OrderedInsertPTGNodeList (PTGNodeList l, PTGNode e, PTGNodeCmpFctType fcmp)
#else
PTGNodeList OrderedInsertPTGNodeList (l, e, fcmp)
        PTGNodeList     l;
        PTGNode e;
        PTGNodeCmpFctType fcmp;
#endif
{
    PTGNodeList p;
    if (!l)
        return (ConsPTGNodeList (e, NULLPTGNodeList));
    if (fcmp (e, l->head) <= 0)
        return (ConsPTGNodeList (e, l));
    p = l;
    while (p->tail && (fcmp (e, p->tail->head) > 0))
        p = p->tail;
    p->tail = ConsPTGNodeList (e, p->tail);
    return (l);
}/* OrderedInsertPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeListPtr RefEndConsPTGNodeList (PTGNodeListPtr addr, PTGNode e)
#else
PTGNodeListPtr RefEndConsPTGNodeList (addr, e)
        PTGNodeListPtr  addr;
        PTGNode         e;
#endif
{
    if (!addr)
    {
        message (DEADLY, "RefEndConsPTGNodeList: no PTGNodeList ref",
                 0, (POSITION*)0);
        return (addr);
    }
    (*addr) = ConsPTGNodeList (e, NULLPTGNodeList);
    return (&((*addr)->tail));
}/* RefEndConsPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeListPtr RefEndAppPTGNodeList (PTGNodeListPtr addr, PTGNodeList l)
#else
PTGNodeListPtr RefEndAppPTGNodeList (addr, l)
        PTGNodeListPtr  addr;
        PTGNodeList             l;
#endif
{
    if (!addr) {
        message (DEADLY, "RefEndAppPTGNodeList: no PTGNodeList ref",
                 0, (POSITION*)0);
        return (addr);
    }
    if (!l)
        return addr;

    (*addr) = l;

    while (l->tail)
        l = l->tail;
    return (&(l->tail));
}/* RefEndAppPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
int ElemInPTGNodeList (PTGNode e, PTGNodeList l, PTGNodeCmpFctType fcmp)
#else
int ElemInPTGNodeList (e, l, fcmp)
        PTGNode e;
        PTGNodeList     l;
        PTGNodeCmpFctType       fcmp;
#endif
{
    while (l != NULLPTGNodeList) {
        if (fcmp (e, l->head) == 0)
            return (1);
        l = l->tail;
    }
    return (0);
}/* ElemInPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList AddToSetPTGNodeList (PTGNode e, PTGNodeList l, PTGNodeCmpFctType fcmp)
#else
PTGNodeList AddToSetPTGNodeList (e, l, fcmp)
        PTGNode e;
        PTGNodeList     l;
        PTGNodeCmpFctType       fcmp;
#endif
{
    if (ElemInPTGNodeList (e, l, fcmp))
        return (l);
    else
        return (ConsPTGNodeList (e, l));
}/* AddToSetPTGNodeList */


#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList AddToOrderedSetPTGNodeList (PTGNode e, PTGNodeList l, PTGNodeCmpFctType fcmp)
#else
PTGNodeList AddToOrderedSetPTGNodeList (e, l, fcmp)
        PTGNode  e;
        PTGNodeList      l;
        PTGNodeCmpFctType fcmp;
#endif
{   int test;
    PTGNodeList  p;
    if (!l)
        return (ConsPTGNodeList (e, NULLPTGNodeList));
    if ((test = fcmp (e, l->head)) < 0)
        return (ConsPTGNodeList (e, l));
    if (test == 0) return l;
    p = l;
    while (p->tail && ((test = fcmp (e, p->tail->head)) > 0))
        p = p->tail;
    if (test) p->tail = ConsPTGNodeList (e, p->tail);
    return (l);
}/* AddToOrderedSetPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList MapPTGNodeList (PTGNodeList l, PTGNodeMapFct f)
#else
PTGNodeList MapPTGNodeList (l, f)
        PTGNodeList     l;
        PTGNodeMapFct f;
#endif
{
    PTGNodeList NewList = NULLPTGNodeList;
    PTGNodeList last = NULLPTGNodeList;

    while (l)
    {
        if (!NewList) {
            NewList = ConsPTGNodeList ((f (l->head)), NULLPTGNodeList);
            last = NewList;
        }
        else
        {
            last->tail = ConsPTGNodeList ((f (l->head)), NULLPTGNodeList);
            last = last->tail;
        }
        l = l->tail;
    }
    return (NewList);
}/* MapPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
int CompPTGNodeList (PTGNodeList l1, PTGNodeList l2, PTGNodeCmpFctType fcmp)
#else
int CompPTGNodeList (l1, l2, fcmp)
        PTGNodeList     l1, l2;
        PTGNodeCmpFctType fcmp;
#endif
{
    int res = 0;
    while (l1 && l2 && (res == 0)) {
        res = (fcmp (l1->head, l2->head));
        l1 = l1->tail;
        l2 = l2->tail;
    }
    if (l1 && !l2)
        return (1);
    if (!l1 && l2)
        return (-1);
    return (res);
}/* CompPTGNodeList */

#if defined(__STDC__) || defined(__cplusplus)
PTGNode SumPTGNodeList (PTGNodeList l, PTGNodeSumFct f, PTGNode a)
#else
PTGNode SumPTGNodeList (l, f, a)
        PTGNodeList     l;
        PTGNode ((*f) ());
        PTGNode a;
#endif
{
    while (l) {
        a = (f (a, l->head));
        l = l->tail;
    }
    return (a);
}/* SumPTGNodeList */
