#ifndef __ENODE_ATTRIBS_H__
#define __ENODE_ATTRIBS_H__


/* Get or set a node attribute.  If value is left out, * returns current
 * value, and does not set */
EBufConst *enode_attrib (ENode * node, gchar * attribute, EBuf * value);

/* Identical to the above, except the change does not trigger * an event.
 * This is to be used _inside renderers only_ (!), to avoid * infinite loops */
EBufConst *enode_attrib_quiet (ENode * node, gchar * attribute, EBuf * value);

/* Identical to first, except value can be specified as a * Plain C string.. 
 * This is strictly for convenience in the C * API.  NULL is returned on an
 * empty/unset attribute to make * testing more convenient */
gchar *enode_attrib_str (ENode * node, gchar * attribute, gchar * value);


/* Return true/false as to whether attribute is true */
gint enode_attrib_is_true (ENode * node, gchar * attrib);

/* Return a list of attributes that are set in this node */
GSList *enode_list_set_attribs (ENode * node);

/* Return a list of all supported attributes for this node */
GSList *enode_supported_attribs (ENode * node);

/* Return a description of the attribute */
gchar *enode_attrib_description (ENode * node, gchar * attribute);

/* Return the common value type for this attribute * (eg, string, integer
 * etc.) */
gchar *enode_attrib_value_type (ENode * node, gchar * attribute);

/* Returns more information about the value.  A comma * seperated list of
 * possible values, a range of integer * values etc. */
gchar *enode_attrib_possible_values (ENode * node, gchar * attribute);

/* Syncronize attributes to renderer by calling the * attribute set notify
 * method for each attribute set * in the node.  Should only be used by
 * renderers */
void enode_attribs_sync (ENode * node);


#endif				/* __ENODE_ATTRIBS_H__ */


