package ENode;

use Carp;


# This lets us printout and veiw $node as the $node->{path}
# as long as we are using it as a string.
use overload 
    '""' 	=> \&path,
    '!'		=> \&__isnotnode,
    'bool' 	=> \&__isanode;

#print ("Loading ENode.pl\n");

#
# Used internally to export methods to other namespaces.
#
sub import
{
    my $caller_package = caller;
    foreach $method (@_) {
        *{"${caller_package}::${method}"} = \&$method;  #{"ENode::${method}"};
    }
}

#
# enode($path): Create a new node given a path (this one is exported)
#
sub enode
{
    ENode->new(@_);
}

#
# enode_rx($regex)
#
sub enode_rx
{
    my $obj = ENode->new('object') or return undef;
    $obj->child_rx(@_);
}

#
# elist($basename, $search)
#
sub elist
{
    my $obj = ENode->new('object') or return undef;
    $obj->children($basename, @_);
}

#
# elist_rx($regex)
#
sub elist_rx
{
    my $obj = ENode->new('object') or return undef;
    $obj->children_rx(@_);
}

#
# ENode->new($path): Create a new enode object.
#
sub new
{
    my ($pkg, $path) = @_;
    my $ptr = Entity::enode_ptr($path);
    return undef unless $ptr;
    Entity::enode_ref($ptr);
    my $self = {};
    tie %$self, ENode::Tied, $ptr;
    bless $self, $pkg;
}

#
# ENode->new_from_ptr($enodeptr): for use from inside entity 
#
sub new_from_ptr
{
    my ($pkg, $ptr) = @_;
    return undef unless $ptr;
    Entity::enode_ref($ptr);
    my $self = {};
    tie %$self, ENode::Tied, $ptr;
    bless $self, $pkg;
}

#
# destructor for releasing node reference 
#
sub DESTROY
{
    my $ptr = (tied %{$_[0]})->[0];
    Entity::enode_unref($ptr) if $ptr;
}

#
# $enode->call(@args): Call a function in another object/lang.
#
sub call
{
    my $ptr = (shift)->__get_enodeptr;
    Entity::enode_call($ptr, @_);
}

#
# $enode->attrib($attr)
# $enode->attrib($attr1 => $value1, $attr2 => $value2, ...)
# Get/set attributes for a node
#
sub attrib
{
    my $ptr = (shift)->__get_enodeptr;
    return Entity::enode_attrib($ptr, @_) if @_ == 1;
    for (my $i=0; $i<@_; $i+=2) {
        Entity::enode_attrib($ptr, $_[$i], $_[$i+1]);
    }
}

#
# $enode->attrib($attr)
# $enode->attrib($attr1 => $value1, $attr2 => $value2, ...)
# Get/set attributes for a node
#
sub attrib_quiet
{
    my $ptr = (shift)->__get_enodeptr;
    return Entity::enode_attrib_quiet($ptr, $_[0]) if @_ == 1;
    for (my $i=0; $i<@_; $i+=2) {
        Entity::enode_attrib_quiet($ptr, $_[$i], $_[$i+1]);
    }
}

#
# $enode->attrib_is_true($attrib):
#   Check the truth of an atrrib. I wonder if we really need this function.
#
sub attrib_is_true
{
    my $ptr = (shift)->__get_enodeptr;
    Entity::enode_attrib_is_true($ptr, @_);
}

#
# $enode->attribs_sync(): Setup the attribs, only needed by userrend.
#
sub attribs_sync
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_attribs_sync($ptr);
}


#
# Key/value storage
#
sub get_kv {
    my $ptr = (shift)->__get_enodeptr;
    return Entity::enode_get_kv($ptr, @_);
}

sub set_kv {
    my $ptr = (shift)->__get_enodeptr;
    Entity::enode_set_kv($ptr, @_);
}

#
# $enode->get_xml(): Get data of a node
#
sub get_xml
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_get_xml($ptr);
}

#
# $enode->get_child_xml(): get xml of child
#
sub get_child_xml
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_get_child_xml($ptr);
}

#
# $enode->append_xml($xml): append xml to node
#
sub append_xml
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_append_xml($ptr, $_[1]);
}

#
# $enode->delete()
#
sub delete
{
    print ("The delete method of the ENode class is deprecated, please use destroy instead.\n");
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_delete($ptr);
}

#
# $enode->delete_children()
#
sub delete_children
{
    print ("The delete_children method of the ENode class is depricated, please use destroy_children instead.\n");
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_delete_children($ptr);
}

#
# $enode->destroy(): Delete tree
#
sub destroy
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_destroy($ptr);
}

#
# $enode->destroy_children()
#
sub destroy_children
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_destroy_children($ptr);
}

#
# $enode->new_child($type, @dunno)
#
sub new_child
{
    my $ptr = (shift)->__get_enodeptr;
    ENode->new_from_ptr( Entity::enode_new_child($ptr, @_) );
}

#
# $enode->child($search)
#
sub child
{
    my $ptr = (shift)->__get_enodeptr;
    my $__enodeptr = Entity::enode_child($ptr, @_);
    ENode->new_from_ptr($__enodeptr);
}

#
# $enode->child($regex)
#
sub child_rx
{
    my $ptr = (shift)->__get_enodeptr;
    my $__enodeptr = Entity::enode_child_rx($ptr, @_);
    ENode->new_from_ptr($__enodeptr);
}

#
# $enode->children($search)
#
sub children
{
    my $ptr = (shift)->__get_enodeptr;
    map {$_ ? ENode->new_from_ptr($_) : ()}
        Entity::enode_children($ptr, @_);
}

#
# $enode->children_rx($regex)
#
sub children_rx
{
    my $ptr = (shift)->__get_enodeptr;
    map {$_ ? ENode->new_from_ptr($_) : ()}
        Entity::enode_children_rx($ptr, @_);
}

#
# $enode->children_attrib($attrib, $value)
#
sub children_attrib
{
    my $ptr = (shift)->__get_enodeptr;
    map {$_ ? ENode->new_from_ptr($_) : ()}
        Entity::enode_children_attrib($ptr, @_);
}

#
# $enode->children_attrib_rx($attrib, $regex)
#
sub children_attrib_rx
{
    my $ptr = (shift)->__get_enodeptr;
    map {$_ ? ENode->new_from_ptr($_) : ()}
        Entity::enode_children_attrib_rx($ptr, @_);
}

#
# $enode->parent($search)
#
sub parent
{
    my $ptr = (shift)->__get_enodeptr;
    ENode->new_from_ptr(Entity::enode_parent($ptr, @_));
}

#
# $enode->get_data()
#
sub get_data
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_get_data($ptr);
}

#
# $enode->set_data($data)
#
sub set_data
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_set_data($ptr, $_[1]);
}

#
# $enode->append_data($data)
#
sub append_data
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_append_data($ptr, $_[1]);
}

#
# $enode->append_data($offset, $data)
#
sub insert_data
{
   my $ptr = (shift)->__get_enodeptr;
   Entity::enode_insert_data($ptr, @_);
}

#
# $enode->delete_data($offset, $count)
#
sub delete_data
{
   my $ptr = (shift)->__get_enodeptr;
   Entity::enode_delete_data($ptr, $offset, $count);
}

#
# $enode->type()
#
sub type
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_type($ptr);
}

#
# $enode->basename()
#
sub basename
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_type($ptr) . '.' . Entity::enode_attrib($ptr, 'name');
}

#
# $enode->list_set_attribs()
#
sub list_set_attribs
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_list_set_attribs($ptr);
}

#
# $enode->supported_attribs()
#
sub supported_attribs
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_supported_attribs($ptr);
}

#
# $enode->attrib_description($attrib)
#
sub attrib_description
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_attrib_description($ptr, $_[1]);
}

#
# $enode->attrib_description($attrib)
#
sub attrib_value_type
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_attrib_value_type($ptr, $_[1]);
}

#
# $enode->attrib_description($attrib)
#
sub attrib_possible_values
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_attrib_possible_values($ptr, $_[1]);
}
    
#
# $enode->write($dunno)
#
sub write
{
    my $ptr = $_[0]->__get_enodeptr;
    Entity::enode_attrib($ptr, '_sendq', $_[1]);
}


#### OVERLOADED OPPERATORS. ####
# Returns path of node
sub path  ## '""'
{
    my $ptr = (tied %{$_[0]})->[0];
    $ptr ? Entity::enode_path($ptr) : undef;
}

sub __isanode  ## 'bool'
{
    (tied %{$_[0]})->[0];
}

sub __isnotnode ## Opposite of isanode.  '!'
{
    not (tied %{$_[0]})->[0];
}

sub __get_enodeptr  ## Called before doing anything special with a node.
{
    my $ptr = (tied %{$_[0]})->[0] or confess("ENode not good.\n");
    $ptr;
}


package ENode::Tied;

sub TIEHASH {
    bless [ $_[1] ], $_[0];
}

sub FETCH {
    my $this = shift;
    Entity::enode_attrib($this->[0], @_);
}

sub STORE {
    my $this = shift;
    Entity::enode_attrib($this->[0], @_);
}

sub DELETE { STORE(@_, ''); }

sub EXISTS { FETCH(@_) ne '' }

sub FIRSTKEY {
    my $this = shift;
    $this->[1] = 0;
    $this->[2] = [ Entity::enode_list_set_attribs($this->[0]) ];
    $this->NEXTKEY();
}

sub NEXTKEY {
    my $this = shift;
    my $attr = ($this->[2])->[ $this->[1]++ ];
    defined($attr) ? ($attr) : ();
}


#print ("Loaded.\n");

return 1;

