#!/usr/bin/env entity

<object>
 <window border = "15" 
   position = "center"
   ondelete = "entity:exit"
   title = "Some Cool App"
   name="windowone">

<object dragable = "true" expand = "false">
   <valign>
     <button name = "do100" onclick="c:count_to_100">
       <label text="test 100"/>
     </button>

     <button name = "do50" onclick="c:count_to_50">
       <label text="test 50"/>
     </button>

     <button name = "docount" count="1000" onclick="c:count_to_count">
       <label text="test 1000"/>
     </button>

     <button name = "testargs_b" data="pass me?" onclick="c:test_args">
       <label text="test args"/>
     </button>

     <button name = "dotest" data="pass me?" onclick="c:dotest">
       <label text="Do a Test"/>
     </button>
   </valign>               

   <c-code name="test1" object="testc" c-libs="-L/usr/lib">
     <![CDATA[
     EBuf *
     dotest(ENode* node, GSList* args)
     {
	 EBuf *path;

	 
         fprintf(stderr, "in dotest\n");
	
	 node = enode ("valign");
	 path = enode_path (node);
	 printf ("path to valign is '%s'\n", path->str);
	 ebuf_free (path);

	 return (NULL);
     }

     void
     entity_c_init (void)
     {
	 EBuf *path;
	 ENode *node;

         fprintf(stderr, "in init function\n");
	
	 node = enode ("valign");
	 path = enode_path (node);
	 printf ("path to valign is '%s'\n", path->str);
	 ebuf_free (path);
     }
     ]]>
   </c-code>

   <c-code name="test2" object="count" >
    <![CDATA[
    EBuf *
    count_to_count (ENode* node, GSList* args)
    {
      int c;
      int count;
      LangArg *arg;
      ENode *button = NULL;

      if (args && args->data) {
          arg = args->data;
          button = arg->data;
      }

      if (button) {
          count = atoi (enode_attrib_str (button, "count", NULL));
          printf ("count = %d\n", count);
          for (c=1; c <= count; c++) {
              fprintf(stderr, "count = %i\t", c);
          }
      } else {
          printf("no node found\n");
      }

      return (NULL);
    }

    EBuf *
    count_to_50(void* node, GSList* args)
    {
      int c;
      for(c=1; c <= 50; c++)
      {
        fprintf(stderr, "count = %i\t", c);
      }
      fprintf(stderr, "\n");
      return (NULL);
    }
    
    EBuf *
    count_to_100(void* node, GSList* args)
    {
      int c;
      for(c=1; c <= 100; c++)
      {
        fprintf(stderr, "count = %i\t", c);
      }
      fprintf(stderr, "\n");
      return (NULL);
    }

    EBuf *
    test_args(void* node, GSList* args)
    {
      fprintf(stderr, "How do you tell if the C code actually compiled,\n" 
    		      "you need to trap the return of the gcc exec\n");
      for(; args; args = args->next)
      {
        fprintf(stderr, "-- %s --\n", args->data);
        //c_call("dotest", NULL, NULL);
      }
      return (NULL);
    }
    ]]>
   </c-code>
  </object>

 </window>

</object>


