#!/usr/bin/env entity

<object>

<object name="test" default-lang="python" __python-namespace="ETest">

	<renderer name="entity-namespace-test"
		tag="test"
		lang="python"
		onrender="test_render"
		ondestroy="test_destroy"
		onparent="test_parent">

		<attrib name="something"
			description="The location of something."
			value_desc="string"
			values="*"
			onset="test_attr_set" />
		
		<python name="test_attr_set"><![CDATA[
def print_namespace(node):
  obj = node.parent("object")
  namespace = obj["__python-namespace"]
  print "namespace is %s" % namespace


def test_attr_set(node, attr, val):
    print "In test node, test node is %s, %s => %s\n" % (node, attr, val)
    print_namespace(node);

def test_attr_set(node, attr, val):
    pass
]]></python>
		
		<python name="test_render"><![CDATA[
def test_render(node, *args):
    print "!!!in test_render!!!"
    print_namespace (node)
]]></python>

                 <python name="test_destroy"><![CDATA[
def test_destroy(node, *args):
    print "!!!in test_destroy!!!"
    print_namespace (node)
]]></python>


		<python name="test_parent"><![CDATA[
def test_parent(node, *args):
    print "in test_parent"
]]></python>

	</renderer>
</object>

<object name="test" ondelete="entity:exit" default-lang="python">
  <test name="foo">
  <python><![CDATA[
def testme(*args):
  test = enode ("test.foo")
  some_func()
  test["something"] == "nothing"
  some_func ()
    	
def some_func(*args):
    print ("in some_func")
]]></python>
  </test>
  
  <window title="Namespace Test">
    <button label="test" onclick="testme"/>
    <button label="exit" onclick="entity:exit"/>
  </window>
</object>

</object>
