# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a base class for all of eric3s XML writers.
"""

import os

from Utilities import escape

class XMLWriterBase:
    """
    Class implementing a base class for all of eric3s XML writers.
    """
    def __init__(self, file):
        """
        Constructor
        
        @param file open file (like) object for writing
        """
        self.pf = file
        
    def _write(self, s, newline=1):
        """
        Protected method used to do the real write operation.
        
        @param s string to be written to the XML file
        @param newline flag indicating a linebreak
        """
        self.pf.write("%s%s" % (s.encode('utf-8'), 
            newline and os.linesep or ""))
        
    def writeXML(self):
        """
        Public method to write the XML to the file.
        """
        # write the XML header
        self._write('<?xml version="1.0" encoding="UTF-8"?>')
