/*****************************************************************************/
/*                                                                           */
/*                                 ICCRON.H                                  */
/*                                                                           */
/* (C) 1996-97  Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// Cron for ESTIC



#ifndef _ICCRON_H
#define _ICCRON_H



#include "datetime.h"



/*****************************************************************************/
/*                                   Data                                    */
/*****************************************************************************/



// Name of the cron file, default is the empty string
extern String CronFile;



/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



void HandleCronEvent (const Time& T);
// Execute all events that match the given time

void ReadCronFile ();
// Delete all existing cron events and reread the cron file. The function
// does nothing if there is no cron file defined.

int ExecuteCronEvent (const String& Event);
// Execute the cron event (without time spec!) given in event. If there are
// parse errors on Event, the function returns FAILURE and the event is not
// executed. Otherwise the event is executed and the function returns the
// result of the execution.



// End of ICCRON.H

#endif

