/***************************************************************************
                          FLFormDB.h  -  description
                             -------------------
    begin                : Sat Jul 28 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLFORMDB_H
#define FLFORMDB_H

#include <qapplication.h>
#include <qlayout.h>
#include <qmessagebox.h>
#include <qwidgetfactory.h>
#include <qobjectlist.h>
#include <qtoolbutton.h>

class FLSqlCursor;
class FLReceiver;

/** Representa un formulario que enlaza con un tabla.

    Se utiliza como contenedor de componentes que quieran
    enlazar con la base de datos y acceder a los registros
    del cursor. Esta estructura simplifica en gran
    medida el acceso a los datos ya que muchas tareas son
    automticamente gestionadas por este formulario contenedor.

    En un principio el formulario se crea vaco y debemos invocar
    el metodo FLFormDB::setMainWidget(), pasandole como parametro
    otro widget (generalmente un formulario creado con QtDesigner),
    el cual contiene distintos componentes, este widget se visualizar
    dentro de este contenedor, autofonfigurandose todos los componentes
    que contiene, con los datos y metadatos del cursor. Generalmente los
    componentes sern plugins, como FLFieldDB o FLTableDB.

    @author   Federico Albujer Zornoza
    @version  0.4*/
class FLFormDB:public QWidget
{
	Q_OBJECT

	public:

	/** constructor.

      	Aqui la clase crea un cursor que es propiedad de FLFormDB y
      	que borra al destruirse. En este caso el nombre de la
      	tabla es establecido con el parametro que se pasa.

      	@param name		Nombre de la tabla origen para el formulario
		@param receiver	Objeto del tipo FLReceiver, que controlar y recibir seales
                        de este formulario. Este objeto pasa a ser propiedad del formulario,
                        y es l quien lo borra. */
  	FLFormDB (const char *name, QWidget * parent = 0,
              WFlags f = Qt::WDestructiveClose,FLReceiver *receiver=0);

	/** constructor sobrecargado.

      	El cursor es pasado a la clase, por lo que no es de su
      	propiedad y por lo tanto no lo debe borrar.

      	@param cursor	Objeto FLSqlCursor para asignar a este formulario.
		@param receiver	Objeto del tipo FLReceiver, que controlar y recibir seales
                        de este formulario. Este objeto pasa a ser propiedad del formulario,
                        y es l quien lo borra. */
  	FLFormDB (FLSqlCursor * cursor, QWidget * parent = 0,
              WFlags f = Qt::WDestructiveClose,FLReceiver *receiver=0);

	/** destructor */
   	virtual ~FLFormDB ();

   	/** Establece el cursor que debe utilizar el formulario.
	
		@param c Cursor con el que trabajar */
	void setCursor(FLSqlCursor *c)
	{
		cursor_=c;
	}
	
	/** Para obtener el cursor utilizado por el formulario.

		return Objeto FLSqlCursor con el cursor que contiene los registros para ser utilizados en el formulario */
  	FLSqlCursor *cursor () const
  	{
    		return cursor_;
  	}

  	/** Para obtener el widget principal del formulario.

		return Objeto QWidget que corresponde con el widget principal del formulario. */
  	QWidget *mainWidget () const
  	{
    		return mainWidget_;
  	}

	/** Establece el identificador MDI */
	void setIdMDI(const QString & id)
	{
		idMDI_=id;
	}

	/** Obtiene el identificador MDI */
	QString idMDI() const
	{
		return idMDI_;
	}

	/** Aade un widget como principal del formulario.

      	Este widget contendr componentes que quieran enlazar con la
      	base de datos, por lo que esperan estar contenidos en una clase
      	FLFormDB, la cual les proporciona el cursor (registros) a los que enlazar.
      	Si ya existiera otro widget como principal, este ser borrado.

      	@param w	Widget principal para el formulario, generalmente ser otro formulario creado con QtDesigner */
  	virtual void setMainWidget (QWidget * w);
  	
  	/** Conecta el botn llamado 'toolButtonExit' contenido en el widget principal, al mtodo
  	     close del formulario FLFormDB que contiene dicho widget principal.
  	
  	      Hay que tener en cuenta que al construir el widget principal si queremos tener un botn que
  	      nos facilite una salida directa del formulario FLFormDB debemos, por ejemplo con
  	      QtDesigner, incluir en l un botn llamado 'toolButtonExit'. */
	void connectButtonClose();
	  	
  	protected:

    /** Captura evento cerrar */
    virtual void closeEvent (QCloseEvent * e);

	/** Cursor, con los registros, utilizado por el formulario */
  	FLSqlCursor * cursor_;

	/** Nombre de la tabla, contiene un valor no vaco cuando
      	la clase es propietaria del cursor */
  	QString name_;

	/** Capa principal del formulario */
  	QVBoxLayout * layout;
  	
  	/** Widget principal del formulario */
  	QWidget *mainWidget_;

    /** Objeto del tipo FLReceiver, que controlar y recibir seales de este formulario */
	FLReceiver *receiver_;

    /** Identificador de ventana MDI.
        Generalmente es el nombre de la accin que abre el formulario. */
    QString idMDI_;

    signals:

    /** Seal emitida cuando se cierra el formulario */
    void closed();
};

#endif
