/***************************************************************************
                          FLTableMetaData.h  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLTABLEMETADATA_H
#define FLTABLEMETADATA_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qvariant.h>
#include <qstring.h>
#include <qlist.h>

class FLFieldMetaData;
class FLRelationMetaData;
class FLCompoundKey;

/** Mantiene la definicion de una tabla.

    	Esta clase mantienen la definicion de
    	ciertas caracteristicas de una tabla de la base
    	de datos, las cuales son utiles para el programa.

    	@author Federico Albujer Zornoza
    	@version 0.4 */
class FLTableMetaData
{
	public:

	/** constructor

      	@param n	Nombre de la tabla a definir
      	@param a	Alias de la tabla, utilizado en formularios
       @param f	Ruta y nombre del formulario, utilizado para editar registros de la tabla,
      				ver FLTableMetaData::pathFormRecord_ */
   	FLTableMetaData (const QString & n, const QString & a, const QString & f );

	/** destructor */
   	~FLTableMetaData ();

	/** Obtiene el nombre de la tabla

      	@return	El nombre de la tabla que se describe */
	const QString & name () const
  	{
    		return name_;
  	}

    /** Establece el nombre de la tabla

      	@param n Nombre de la tabla */
	void setName (const QString &n)
  	{
    		name_ = n;
  	}

	/** Obtiene el alias asociado a la tabla */
  	const QString & alias () const
  	{
    		return alias_;
  	}

	/** Obtiene la ruta y nombre del formulario (fichero .ui) que se debe utiliza para editar registros de la tabla */
  	const QString & pathFormRecord () const
  	{
    		return pathFormRecord_;
  	}

 	/** Aade la descripcin de un campo a lista de descripciones de campos, de esta descripcion de tabla.

      	@param f	Objeto FLFieldMetaData con la descripcin del campo a aadir */
  	void addFieldMD (const FLFieldMetaData * f);

  	/** Aade una clave compuesta a la lista de claves compuestas de esta tabla.

      	@param cK	Objeto FLCompoundKey con la descripcin de la clave compuesta a aadir */
  	void addCompoundKey (const FLCompoundKey * cK);
  	
	/** Obtiene el nombre del campo que es clave primaria para esta tabla. */
	const QString primaryKey();
	
	/** Obtiene el alias de un campo a partir de su nombre.
	
		@param fN	Nombre del campo */
  	const QString fieldNameToAlias (const QString & fN);

	/** Obtiene el nombre de un campo a partir de su alias.
	
		@param aN	Nombre del alias del campo */
  	const QString fieldAliasToName (const QString & aN);

	/** Obtiene el tipo de un campo a partir de su nombre.
		
		@param fN	Nombre del campo */
  	const int fieldType (const QString & fN);

	/** Obtiene si un campo es clave primaria partir de su nombre.
	
		@param fN Nombre del campo */
  	const bool fieldIsPrimaryKey (const QString & fN);

  	/** Obtiene si un campo es ndice a partir de su nombre.
	
		@param fN Nombre del campo */
  	const bool fieldIsIndex (const QString & fN);
  	
  	 /** Obtiene si un campo es contador.
                                 @param fN Nombre del campo
                                 @author Andrs Otn Urbano (baxas@eresmas.com)*/
                    const bool fieldIsCounter (const QString & fN);

                  /** Obtiene si un campo es nico a partir de su nombre.
	
		@param fN Nombre del campo */
  	const bool fieldIsUnique (const QString & fN);
  	
  	/** Obtiene el nombre de la tabla fornea relacionada con un campo de esta tabla mediante
		una relacion M1 (muchos a uno).
	
		@param fN	Campo de la relacion M1 de esta tabla, que se supone que esta relacionado
					con otro campo de otra tabla
      	@return	El nombre de la tabla relacionada M1, si hay relacion para el campo, o una cadena
      			vacia sin el campo no est relacionado */
    	const QString fieldTableM1 (const QString & fN);

	/** Obtiene el nombre del campo de la tabla fornea relacionado con el indicado mediante
		una relacion M1 (muchos auno).

      	@param fN	Campo de la relacion M1 de esta tabla, que se supone que esta relacionado
      				con otro campo de otra tabla
     	@return	El nombre del campo forneo relacionado con el indicado */
    const QString fieldForeignFieldM1 (const QString & fN);

    /** Obtiene el objeto relacin que definen dos campos.
    	
        @param fN   Nombre del campo de esta tabla que forma parte de la relacin.
        @param fFN  Nombre del campo forneo a esta tabla que forma parte de la relacin.
        @return	        Devuelve un objeto FLRelationMetaData con la informacin de la relacin, siempre y
       			cuando esta exista. Si no existe devuleve 0*/
    FLRelationMetaData *relation(const QString& fN,const QString&fFN);
   	
    /** Obtiene la longitud de un campo a partir de su nombre.
    	
    	@param fN	Nombre del campo */
    const int fieldLength(const QString & fN);
    	
    /** Obtiene el nmero de dgitos de la parte entera de un campo a partir de su nombre.
    	
    	@param fN	Nombre del campo */
    const int fieldPartInteger(const QString & fN);
    	
    /** Obtiene el nmero de dgitos de la parte decimal de un campo a partir de su nombre.
    	
    	@param fN	Nombre del campo */
    const int fieldPartDecimal(const QString & fN);
    	
    /** Obtiene si un campo es calculado.
    	
    	@param fN	Nombre del campo */
    const bool fieldCalculated(const QString & fN);
    	
    /** Obtiene si un campo es visible.
    	
    	@param fN	Nombre del campo */
    const bool fieldVisible(const QString & fN);
    	
    /** Obtiene los metadatos de un campo.
    	
    	@param fN	Nombre del campo
    	@return	Un objeto FLFieldMetaData con lainformacin o metadatos de un campo dado */
    FLFieldMetaData *field(const QString & fN);
    	    					
    /** Tipo de datos lista de campos */
    typedef QList < FLFieldMetaData > FLFieldMetaDataList;

    /** Tipo de datos lista de claves compuestas */
    typedef QList < FLCompoundKey > FLCompoundKeyList;
    	
	/**  Asigna una lista de campos, a la lista de campos de la tabla.

         La lista de campos del tipo FLFieldMetaDataList, ya construida,
         es asignada como la lista de campos de la tabla, en el caso de que
         ya exista una lista de campos  para la tabla, esta es destruida y
         sobreescrita por la nueva. La lista pasada a este mtodo pasa a ser
         propiedad de la tabla, y ella es la encargada de borrarla, por lo tanto no se
         debe borrar esta lista fuera de la clase. Si la lista que se pretende asignar
         es nula o vaca este mtodo no hace nada.

         @param fl  Lista de campo */
    void setFieldList (FLFieldMetaDataList *fl);


    /**  Asigna una lista de claves, a la lista de claves compuestas de la tabla.

         La lista de claves del tipo FLCompoundKeyList, ya construida,
         es asignada como la lista de claves compuestas de la tabla, en el caso de que
         ya exista una lista de claves compuestas para la tabla, esta es destruida y
         sobreescrita por la nueva. La lista pasada a este mtodo pasa a ser
         propiedad de la tabla, y ella es la encargada de borrarla, por lo tanto no se
         debe borrar esta lista fuera de la clase. Si la lista que se pretende asignar
         es nula o vaca este mtodo no hace nada.

         @param cl  Lista de claves */
    void setCompoundKeyList (FLCompoundKeyList *cl);

    /** Para obtener la lista de definiciones de campos.

      	@return	Objeto con la lista de deficiones de campos de la tabla */
  	FLFieldMetaDataList *fieldList () const
  	{
    		return fieldList_;
  	}

  	/** Obtiene la lista de campos de una clave compuesta, a partir del nombre de
    	un campo del que se quiere averiguar si est en esa clave compuesta.
    		
    	@param fN	Nombre del campo del que se quiere averiguar si pertenece a una clave compuesta.
    	@return Si el campo pertenece a una clave compuesta, devuelve la lista de campos
    			que forman dicha clave compuesta, incluido el campo consultado. En el caso
    			que el campo consultado no pertenezca a ninguna clave compuesta devuelve 0 */
   	FLFieldMetaDataList *fieldListOfCompoundKey(const QString & fN);
    	
	private:

	/** Nombre de la tabla */
       QString name_;

	/** Alias de la tabla */
  	QString alias_;

	/** Mantiene ruta y nombre del fichero .ui con la definicion del formulario que se debe utilizar para
		editar registros de la tabla */
  	QString pathFormRecord_;

 	/** Lista de campos que tiene esta tabla */
  	FLFieldMetaDataList *fieldList_;
  	
  	/** Lista de claves compuestas que tiene esta tabla */
  	FLCompoundKeyList *compoundKeyList_;
};

#endif
