/***************************************************************************
                          filelightcanvas.h  -  description
                             -------------------
    begin                : Sun May 25 2003
    copyright            : (C) 2003 by Max Howell
    email                : mh9193@bris.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILELIGHTCANVAS_H
#define FILELIGHTCANVAS_H
 
#include <qwidget.h>


class Directory;
class File;
class FileMap;
class SegmentTip;
class Segment;
class KMainWindow;
class KActionCollection;
class KAction;
class KURL;
class QStatusBar;
class QString;
class QTimer;
class QPoint;

class FilelightCanvas : public QWidget
{
  Q_OBJECT
  
  public:
    FilelightCanvas( QStatusBar *, KMainWindow * = 0, const char * = 0 );
    virtual ~FilelightCanvas();

    //**** you wish you didn't need this really, although I don't know exactly why
    const QString& path() const { return m_path; }
    bool isValid() const { return (m_tree != NULL); }

  public slots:
    void create( const Directory * );
    void createFromCache( const Directory * );
    void invalidate( const bool & = true );
    
    void refresh( int );

  private slots:
    void slotKonqiHere();
    void slotKonsoleHere();
    void slotRun();
    void slotCenterHere();
    void slotRemoveFileOrDir();    
    void slotZoomIn();
    void slotZoomOut();    

    void slotResizeTimeout();
    void slotPostMouseEvent();
                                                                                                                                                
  signals:
     void invalidated( const KURL & );
     void created( const Directory * );
     void rescan();

  protected:
    virtual void paintEvent( QPaintEvent * );
    virtual void resizeEvent ( QResizeEvent * );
    virtual void mouseMoveEvent( QMouseEvent * );
    virtual void mousePressEvent( QMouseEvent * );
    
  private:
    const Segment *segmentAt( QPoint & ) const;
    void paintExplodedLabels( QPainter & ) const;        

    const Directory *m_tree;
    const Segment   *m_focus;
    QPoint      m_offset;
    QString     m_path;

    QTimer     *m_timer;
    QStatusBar *m_status;
    FileMap    *m_map;
    SegmentTip *m_tip;

    KActionCollection *m_actionJug;

    KAction *m_actKonqi;
    KAction *m_actKonsole;
    KAction *m_actCenter;
    KAction *m_actRun;
};

#endif
