/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.4 $
 *
 * $Log: util.c,v $
 * Revision 1.4  2003/06/19 17:11:20  tim
 * new memory management
 * removed the fragment list
 *
 * Revision 1.3  2003/03/07 18:56:02  tim
 * *** empty log message ***
 *
 * Revision 1.2  2002/11/28 22:53:21  tim
 * copy_argv function from tcpdump util.c
 *
 * Revision 1.1  2002/11/24 23:13:38  tim
 * Initial revision
 *
 *
 */

#include <sys/time.h>
#include <stdio.h>
#include <sys/types.h>
#include "fprobe.h"

unsigned long timestamp(struct timeval *time) {
  struct timeval tv;
  unsigned long t;

  if (time == NULL) {
    gettimeofday(&tv, NULL);
    return tv.tv_sec;
  } else {
    return time->tv_sec;
  }
    
  /*
   *  t = tv.tv_sec * 100;
   * t+= (tv.tv_usec / 10000);
   */
}


/*
 * Copy arg vector into a new buffer, concatenating arguments with spaces.
 * from tcpdump util.c
 */
char *
copy_argv(register char **argv)
{
        register char **p;
        register u_int len = 0;
        char *buf;
        char *src, *dst;

        p = argv;
        if (*p == 0)
                return 0;

        while (*p)
                len += strlen(*p++) + 1;

        buf = (char *)MALLOC(len,5);
        if (buf == NULL)
                error("copy_argv: malloc");

        p = argv;
        dst = buf;
        while ((src = *p++) != NULL) {
                while ((*dst++ = *src++) != '\0')
                        ;
                dst[-1] = ' ';
        }
        dst[-1] = '\0';

        return buf;
}

