CFLAGS=-O2 -g -Wall -DMACHINE_ARCH='\"$(DEB_BUILD_GNU_CPU)\"'
MAKE_BUILD_FLAGS= COPTS="$(CFLAGS)" NO_WERROR=1 NOGCCERROR=1 NOSHARED=NO
# NO_WERROR for fmake, NOGCCERROR for pmake

PMAKE=pmake
YACC=`ls $(CURDIR)/$(DEB_SRCDIR)/usr.bin/yacc/yacc 2>/dev/null || which yacc`

SUBDIRS=$(BINDIRS) $(SBINDIRS)

build/freebsd-buildutils:: apply-patches
	cd $(DEB_SRCDIR)/usr.bin/yacc ; \
		$(PMAKE) $(MAKE_BUILD_FLAGS)

	cd $(DEB_SRCDIR)/contrib/one-true-awk ; \
		$(YACC) -d -o awkgram.c ../../contrib/one-true-awk/awkgram.y
	cd $(DEB_SRCDIR)/usr.bin/awk ; \
		ln -sf ../../contrib/one-true-awk/awkgram.h ytab.h ; \
		$(PMAKE) $(MAKE_BUILD_FLAGS)

	cd $(DEB_SRCDIR)/usr.bin/cksum ; $(PMAKE) $(MAKE_BUILD_FLAGS)

	cd $(DEB_SRCDIR)/usr.bin/lex ; \
		$(PMAKE) bootstrap ; \
		$(YACC) -d -o parse.c parse.y ; \
		$(PMAKE) $(MAKE_BUILD_FLAGS)

	cd $(DEB_SRCDIR)/usr.bin/make ; \
		$(PMAKE) $(MAKE_BUILD_FLAGS)

	cd $(DEB_SRCDIR)/usr.bin/mkdep ; $(PMAKE) $(MAKE_BUILD_FLAGS)

	cd $(DEB_SRCDIR)/usr.sbin/config ; \
		$(YACC) -d config.y ; \
		cp y.tab.c config.c ; \
		$(PMAKE) $(MAKE_BUILD_FLAGS)

#	cd $(DEB_SRCDIR)/usr.sbin/btxld ; $(PMAKE) $(MAKE_BUILD_FLAGS)

	cd $(DEB_SRCDIR)/usr.sbin/mtree ; $(PMAKE) $(MAKE_BUILD_FLAGS)

binary/freebsd-buildutils:: common-install-prehook-arch
	install -m 755 -o root -g root -d debian/freebsd-buildutils
	for i in $(MKDIR) ; do \
		install -m 755 -o root -g root -d \
			debian/freebsd-buildutils/$$i; \
	done
	for i in awk cksum lex make mkdep yacc ; do \
		cd $(CURDIR)/$(DEB_SRCDIR)/usr.bin/$$i; \
		$(PMAKE) install DESTDIR=$(CURDIR)/debian/freebsd-buildutils BINDIR=/usr/bin ; \
	done
	# btxld
	for i in mtree config ; do \
		cd $(CURDIR)/$(DEB_SRCDIR)/usr.sbin/$$i; \
		$(PMAKE) install DESTDIR=$(CURDIR)/debian/freebsd-buildutils BINDIR=/usr/sbin ; \
	done
	cd $(DEB_SRCDIR)/share/mk ; \
		$(PMAKE) install \
		DESTDIR=$(CURDIR)/debian/freebsd-buildutils BINDIR=/usr/share

	# remove trash
	rm -rf debian/$(cdbs_curpkg)/usr/lib \
		debian/$(cdbs_curpkg)/usr/include \
		debian/$(cdbs_curpkg)/usr/share/man \
		debian/$(cdbs_curpkg)/var

	# rename awk
	mv debian/$(cdbs_curpkg)/usr/bin/nawk \
		debian/$(cdbs_curpkg)/usr/bin/awk

	# relocate binaries
	mkdir -p debian/$(cdbs_curpkg)/usr/lib/freebsd
	mv \
		debian/$(cdbs_curpkg)/usr/bin/* \
		debian/$(cdbs_curpkg)/usr/sbin/* \
		debian/$(cdbs_curpkg)/usr/lib/freebsd/
	for i in `cd debian/$(cdbs_curpkg)/usr/lib/freebsd && ls` ; do \
		ln -s ../lib/freebsd/$$i \
		debian/$(cdbs_curpkg)/usr/bin/freebsd-$$i ; \
	done
	rmdir debian/$(cdbs_curpkg)/usr/sbin

	# make stuff
	mv debian/$(cdbs_curpkg)/usr/share/mk \
		debian/$(cdbs_curpkg)/usr/share/fbmk
