dnl -*- Mode: Autoconf -*- 
dnl	$Id: acinclude.m4,v 1.7 2004/04/22 16:52:03 delpinux Exp $	

AC_DEFUN(AC_CHECK_LIBOPTS,
[
  AH_TEMPLATE(HAVE_LIBOPTS,
   [Defined to 1 if the autogen is used to parse command line options])
  AC_CHECK_LIB([opts], [optionRestore],have_libopts=true,have_libopts=false)
  AM_CONDITIONAL(LIBOPTS,test x$have_libopts = xtrue)
  if test x$have_libopts = xtrue
  then
    AC_DEFINE(HAVE_LIBOPTS)
  fi
])

AC_DEFUN(AC_CHECK_LIBVTK,
[
  AC_ARG_ENABLE(
  vtk,
  AC_HELP_STRING([--enable-vtk],[allow rendering using VTK library]),
  [ ac_vtk=$enableval ],
  [ ac_vtk="auto"])

  AH_TEMPLATE(HAVE_LIBVTK,
   [Defined to 1 if VTK sources (>= 4.0) are present on the system])

  AC_MSG_CHECKING([for VTK library (>= 4.0)])

  have_libvtk=false
  vtkinclude=""
dnl look for vtk in standard pathes
  for i in /usr/include /usr/local/include
  do
    if test -e "$i/vtk/vtkConfigure.h"
    then
      have_libvtk=true
      vtkinclude=$i/vtk
    fi
  done

  AM_CONDITIONAL(LIBVTK,test x$have_libvtk = xtrue -a x$ac_vtk != xno)
  if test x$have_libvtk = xtrue
  then
	case $ac_vtk in
	("yes"|"auto")
	    AC_DEFINE(HAVE_LIBVTK)
	    CPPFLAGS="$CPPFLAGS -I$vtkinclude"
	    AC_MSG_RESULT(yes)
	  ;;
	"no")
	    AC_MSG_RESULT(yes (but not activated as it was request))
	  ;;
	  *)
	    AC_MSG_ERROR(acinclude error! Should not reach that case.)
          ;;
	esac
  else
	case $ac_vtk in
	"yes")
	    AC_MSG_RESULT(no)
	    AC_MSG_ERROR(You requiered vtk which is not present on your system!)
	  ;;
	("auto"|"no")
	    AC_MSG_RESULT(no)
	  ;;
	  *)
	    AC_MSG_ERROR(acinclude error! Should not reach that case.)
          ;;
	esac
  fi
])

AC_DEFUN(AC_CHECK_COMPILE_OPTS,
[

dnl Checking which definition to use for real_t.
  AC_ARG_ENABLE(
  real_t,
  AC_HELP_STRING([--enable-real_t],[sets real_t to float or double (default=double)]),
  [ ac_real_t=$enableval ],
  [ ac_real_t="double"])

  AH_TEMPLATE(HAVE_REAL_TYPE,
   [Defined real_t (1:double, 2:float)])

  case $ac_real_t in
  "double")
    AC_DEFINE(HAVE_REAL_TYPE,1)
    ;;
  "float")
    AC_DEFINE(HAVE_REAL_TYPE,2)
    ;;
  *)
    AC_MSG_ERROR(real_t can only be defined as "double" or "float")
    ;;
  esac

dnl Enalbe or not system "exec" command
  AH_TEMPLATE(ALLOW_EXEC,
   [allow use of exec command])

  AC_ARG_ENABLE(
  exec,
  AC_HELP_STRING([--enable-exec],[allows use of exec command (default=yes)]),
  [
   if test $enableval = "no";
     then ac_use_exec_code="no"
     else ac_use_exec_code="yes"
   fi
  ], [ac_use_exec_code="yes"])

  if test $ac_use_exec_code = "yes"
  then
	AC_DEFINE(ALLOW_EXEC)
  fi

dnl Check debugging mode for compilation.
  AC_ARG_ENABLE(
  debug,
  AC_HELP_STRING([--enable-debug],[creates debugging code (default=no)]),
  [
   if test $enableval = "no";
     then ac_use_debug_code="no"
     else ac_use_debug_code="yes"
   fi
  ], [ac_use_debug_code="no"])

  AC_ARG_ENABLE(
  optimize,
  AC_HELP_STRING([--enable-optimize],[creates optimized code (default=no)]),
  [
   if test $enableval = "no";
     then ac_use_opt_code="no"
     else ac_use_opt_code="yes"
   fi
  ], [ac_use_opt_code="no"])

  if test $ac_use_debug_code = "yes" -a $ac_use_opt_code = "yes"
  then
    AC_MSG_ERROR(Cannot use --enable-debug and --enable-optimize together!)
  fi

  if test $ac_use_debug_code = "yes"
  then
    CXXFLAGS="-g -Wall"
    CFLAGS="-g -Wall"
    CXXLANGUAGEFLAGS="-g -Wall"
  else
    if test $ac_use_opt_code = "yes"
    then
      CXXFLAGS="-Wall -DNDEBUG -O2 -funroll-all-loops -fargument-noalias-global -fno-gcse"
      CFLAGS="-Wall -DNDEBUG -O2 -funroll-all-loops -fargument-noalias-global -fno-gcse"
      CXXLANGUAGEFLAGS="-Wall -DNDEBUG -O1 -funroll-all-loops -fargument-noalias-global -fno-gcse"
    else
      CXXFLAGS="$CXXFLAGS -Wall -DNDEBUG"
      CFLAGS="$CFLAGS -Wall -DNDEBUG"
      CXXLANGUAGEFLAGS="-g -Wall -DNDEBUG"
    fi
  fi

  AC_SUBST(CXXLANGUAGEFLAGS)

])
