/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: DialogData.cpp,v 1.5 2004/04/11 20:08:12 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "utils.h"

#include "DialogData.h"

#include "fwbuilder/FWObject.h"

#include <qwidget.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qtextview.h>

#include <iostream>

using namespace std;
using namespace libfwbuilder;

DialogOption::DialogOption(QWidget *_w, FWObject *_o, const char* _a)
{
    w       = _w;
    obj     = _o;
    attr    = _a;

    dtype   = Unknown;

    if (dynamic_cast<QComboBox*>(w)!=NULL)    dtype=String;
    if (dynamic_cast<QCheckBox*>(w)!=NULL)    dtype=Bool;
    if (dynamic_cast<QLineEdit*>(w)!=NULL)    dtype=String;
    if (dynamic_cast<QTextView*>(w)!=NULL)    dtype=String;
    if (dynamic_cast<QRadioButton*>(w)!=NULL) dtype=Bool;
    if (dynamic_cast<QSpinBox*>(w)!=NULL)     dtype=Int;
}

DialogOption::DialogOption(QWidget *_w, FWObject *_o, const char* _a,QStringList _m)
{
    w       = _w;
    obj     = _o;
    attr    = _a;
    mapping = _m;

    dtype   = Unknown;

    if (dynamic_cast<QComboBox*>(w)!=NULL)    dtype=String;
    if (dynamic_cast<QCheckBox*>(w)!=NULL)    dtype=Bool;
    if (dynamic_cast<QLineEdit*>(w)!=NULL)    dtype=String;
    if (dynamic_cast<QTextView*>(w)!=NULL)    dtype=String;
    if (dynamic_cast<QRadioButton*>(w)!=NULL) dtype=Bool;
    if (dynamic_cast<QSpinBox*>(w)!=NULL)     dtype=Int;
}


DialogData::DialogData() {}
DialogData::~DialogData()
{
    options.clear();
}

void DialogData::clear()
{
    options.clear();
}

void DialogData::registerOption(QWidget *widget, libfwbuilder::FWObject *obj, const char* attr)
{
    options.push_back( DialogOption(widget,obj,attr) );
}

void DialogData::registerOption(QWidget *widget, libfwbuilder::FWObject *obj, const char* attr,QStringList mapping)
{
    options.push_back( DialogOption(widget,obj,attr,mapping) );
}

void DialogData::loadToWidget( DialogOption &dopt , bool override)
{
    if (dynamic_cast<QComboBox*>(dopt.w)!=NULL)
    {
        QComboBox *cbx = dynamic_cast<QComboBox*>(dopt.w);
        QString      s = (override) ? dopt.override_str_val : QString(dopt.obj->getStr(dopt.attr.latin1()).c_str());
        QListBox  *lbx = cbx->listBox();
        if (!dopt.mapping.empty())
        {
/*
 * REMINDER:
 * Mapping is defined by an array of strings in the following format:
 *
 *     "Linux 2.4" , "linux24",
 *     "IPFilter"  , "ipf",
 *     "Cisco PIX" , "pix",
 *     NULL,         NULL
 *
 *  Odd strings correspond to the data in the widget, while even
 *  strings define what is stored in the object (counting strings in
 *  the array from 1).
 */
            QStringList::iterator i1 = dopt.mapping.begin();
            QStringList::iterator i2 = dopt.mapping.begin();
            ++i2;
            while (i2!=dopt.mapping.end())
            {
                if (s== (*i2)) { s= *i1; break; }
                i1++; i1++;
                i2++; i2++;
            }
        }
/*
 * TODO: it would be nice if it was possible to find entries in combox
 * box using regular expressions. QListBox does not support regex
 * match though.
 */
        int idx=lbx->index( lbx->findItem(s,Qt::ExactMatch) );
        cbx->setCurrentItem( (idx<0)?0:idx );
    }
    if (dynamic_cast<QCheckBox*>(dopt.w)!=NULL)
    {
        QCheckBox *cbx=dynamic_cast<QCheckBox*>(dopt.w);
        cbx->setChecked( (override)?dopt.override_int_val:dopt.obj->getBool(dopt.attr.latin1()) );
    }
    if (dynamic_cast<QLineEdit*>(dopt.w)!=NULL)
    {
        QLineEdit *edit=dynamic_cast<QLineEdit*>(dopt.w);
        edit->setText( (override) ? dopt.override_str_val : QString(dopt.obj->getStr(dopt.attr.latin1()).c_str()) );
    }
    if (dynamic_cast<QTextView*>(dopt.w)!=NULL)
    {
        QTextView *edit=dynamic_cast<QTextView*>(dopt.w);
        edit->setText( (override) ? dopt.override_str_val : QString(dopt.obj->getStr(dopt.attr.latin1()).c_str()) );
    }
    if (dynamic_cast<QRadioButton*>(dopt.w)!=NULL)
    {
        QRadioButton *rbtn=dynamic_cast<QRadioButton*>(dopt.w);
        rbtn->setChecked( (override)?dopt.override_int_val:dopt.obj->getBool(dopt.attr.latin1()) );
    }
    if (dynamic_cast<QSpinBox*>(dopt.w)!=NULL)
    {
        QSpinBox *sbx = dynamic_cast<QSpinBox*>(dopt.w);
        sbx->setValue( (override)?dopt.override_int_val:dopt.obj->getInt(dopt.attr.latin1()) );
    }
}
    

void DialogData::loadAll()
{
    for (list<DialogOption>::iterator i=options.begin(); i!=options.end(); ++i)
        loadToWidget( *i );
}

void DialogData::saveAll()
{
    for (list<DialogOption>::iterator i=options.begin(); i!=options.end(); ++i)
    {

        if (dynamic_cast<QComboBox*>(i->w)!=NULL)
        {
            QComboBox *cbx = dynamic_cast<QComboBox*>(i->w);
            QString      s = cbx->currentText();
            if ( !i->mapping.empty() && !s.isNull() )
            {
/*
 * REMINDER:
 * Mapping is defined by an array of strings in the following format:
 *
 * char *mapping[] = {
 *     "Linux 2.4" , "linux24",
 *     "IPFilter"  , "ipf",
 *     "Cisco PIX" , "pix",
 *     NULL,         NULL
 *  };
 *
 *  Odd strings correspond to the data in the widget, while even
 *  strings define what is stored in the object (counting strings in
 *  the array from 1).
 */
                QStringList::iterator i1 = i->mapping.begin();
                QStringList::iterator i2 = i->mapping.begin();
                ++i2;
                while (i2!=i->mapping.end())
                {
                    if (s== (*i1)) { s= *i2; break; }
                    i1++; i1++;
                    i2++; i2++;
                }
            }
            if (s.isEmpty()) s="";
            i->obj->setStr(i->attr.latin1(), s.latin1());
        }
        if (dynamic_cast<QCheckBox*>(i->w)!=NULL)
        {
            QCheckBox *cbx=dynamic_cast<QCheckBox*>(i->w);
            i->obj->setBool(i->attr.latin1(), cbx->isChecked() );
        }
        if (dynamic_cast<QLineEdit*>(i->w)!=NULL)
        {
            QLineEdit *edit=dynamic_cast<QLineEdit*>(i->w);
            i->obj->setStr(i->attr.latin1(), edit->text().latin1() );
        }
        if (dynamic_cast<QTextView*>(i->w)!=NULL)
        {
            QTextView *edit=dynamic_cast<QTextView*>(i->w);
            i->obj->setStr(i->attr.latin1(), edit->text().latin1() );
        }
        if (dynamic_cast<QRadioButton*>(i->w)!=NULL)
        {
            QRadioButton *rbtn=dynamic_cast<QRadioButton*>(i->w);
            i->obj->setBool(i->attr.latin1(), rbtn->isChecked() );
        }
        if (dynamic_cast<QSpinBox*>(i->w)!=NULL)
        {
            QSpinBox *sbx = dynamic_cast<QSpinBox*>(i->w);
            i->obj->setInt( i->attr.latin1(), sbx->value() );
        }

    }
}

void DialogData::setWidgetValue(const char *attr,const QString &val)
{
    for (list<DialogOption>::iterator i=options.begin(); i!=options.end(); ++i)
    {
        if (i->attr == attr)
        {
            i->overrideValue(val);
            loadToWidget( *i , true );
            break;
        }
    }
}


void DialogData::setWidgetValue(const char *attr,int val)
{
    for (list<DialogOption>::iterator i=options.begin(); i!=options.end(); ++i)
    {
        if (i->attr == attr)
        {
            i->overrideValue(val);
            loadToWidget( *i , true );
            break;
        }
    }
}


