//
// $Source: /cvsroot/gambit/gambit/sources/gcl/Attic/command.h,v $
// $Date: 2002/08/27 18:57:16 $
// $Revision: 1.2 $
//
// DESCRIPTION:
// Declaration of abstract command-line GCL class
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef COMMAND_H
#define COMMAND_H

namespace GCL {

class CommandLine : public gInput {
private:
  int m_historyDepth;

protected:
  virtual char GetNextChar(void) = 0;

public:
  CommandLine(int p_historyDepth) : m_historyDepth(p_historyDepth) { }
  virtual ~CommandLine() { }

  int HistoryDepth(void) const { return m_historyDepth; }

  virtual void SetPrompt(bool) = 0;
};

}  // namespace GCL

#endif  // COMMAND_H

