/* sqlqueryenv.h
 *
 * Copyright (C) 2001 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_QUERY_ENV__
#define __SQL_QUERY_ENV__

#include <gnome.h>
#include "sqlquery.h"
#include "gasql_conf.h"
#include "sqldb.h"

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define SQL_QUERY_ENV(obj)          GTK_CHECK_CAST (obj, sql_query_env_get_type(), SqlQueryEnv)
#define SQL_QUERY_ENV_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_query_env_get_type (), SqlQueryEnvClass)
#define IS_SQL_QUERY_ENV(obj)       GTK_CHECK_TYPE (obj, sql_query_env_get_type ())


	typedef struct _SqlQueryEnv SqlQueryEnv;
	typedef struct _SqlQueryEnvClass SqlQueryEnvClass;
	typedef enum _SqlQueryActions SqlQueryActions;

	/* all the actions that can be done from a Form (and some from a Grid) */
	enum _SqlQueryActions
	{
		QUERY_ACTION_FIRST = 1 << 0,	/* move to the first record of the result */
		QUERY_ACTION_LAST = 1 << 1,
		QUERY_ACTION_PREV = 1 << 2,
		QUERY_ACTION_NEXT = 1 << 3,
		QUERY_ACTION_INSERT = 1 << 4,	/* Ask for a new empty Form */
		QUERY_ACTION_COMMIT = 1 << 5,	/* commit the changes done */
		QUERY_ACTION_DELETE = 1 << 6,
		QUERY_ACTION_CHOOSE = 1 << 7,	/* when the user is prompted for a value */
		QUERY_ACTION_REFRESH = 1 << 8,	/* ask to refresh */
		QUERY_ACTION_EDIT = 1 << 9,
		QUERY_ACTION_VIEWALL = 1 << 10,
		QUERY_ACTION_LAST_ENUM
	};

	/* struct for the object's data */
	struct _SqlQueryEnv
	{
		GtkObject object;

		SqlQuery *q;
		SqlMemTable *modif_table;
		gchar *name;
		gchar *descr;

		guint actions;	/* default possible actions (OR'ed SqlQueryActions) */
		gboolean no_insert;	/* TRUE when we don't have enough info to insert new data */

		gpointer form;	/* libglade struct for the form, or NULL */
		gboolean form_is_default;	/* TRUE if a form is created by default (otherwise a grid) */

		GtkWidget *edit_dlg;	/* dialog to edit the env */

		GSList *execs_list;	/* list of all the SqlQueryExec objects associated */
	};

	/* struct for the object's class */
	struct _SqlQueryEnvClass
	{
		GtkObjectClass parent_class;

		void (*query_changed) (SqlQueryEnv * qe);
		void (*descr_changed) (SqlQueryEnv * qe);
		void (*type_changed) (SqlQueryEnv * qe);	/* defaults as form or grid */
	};

	/* generic widget's functions */
	guint sql_query_env_get_type (void);
	GtkObject *sql_query_env_new (SqlQuery * q);
	void sql_query_env_free (SqlQueryEnv * env);

	/* register the attached SqlQueryExec objects to maintain the execs_list list */
	void sql_query_env_register_exec_obj (SqlQueryEnv * env,
					      GtkObject * obj);

	void sql_query_env_set_descr (SqlQueryEnv * env, gchar * descr);
	void sql_query_env_set_name (SqlQueryEnv * env, gchar * name);
	void sql_query_env_set_modif_table (SqlQueryEnv * env,
					    SqlMemTable * table);

	/* get a widget to edit the properties of the SqlQueryEnv
	   also uses the env->edit_dlg property */
	GtkWidget *sql_query_env_show_props_dialog (SqlQueryEnv * env);

#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
