/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/cellrenderersignals.hh
/// @brief Gtk::CellRenderer virtual signal handlers.
///
/// Provides Gtk::CellRendererSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::CellRenderer objects.

#ifndef GFC_GTK_CELL_RENDERER_SIGNALS_HH
#define GFC_GTK_CELL_RENDERER_SIGNALS_HH

#ifndef GFC_GTK_OBJECT_SIGNALS_HH
#include <gfc/gtk/objectsignals.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class CellRendererSignals cellrenderersignals.hh gfc/gtk/cellrenderersignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::CellRenderer.

class CellRendererSignals : public ObjectSignals
{
protected:
/// @name Constructors
/// @{

	CellRendererSignals(CellRenderer *cell);
	///< Construct a new CellRendererSignals object.	
	///< @param cell A CellRenderer object inheriting the CellRendererSignals implementation.
	
	virtual ~CellRendererSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	void on_editing_canceled();
	///< Called to notify a client program that an editing process was canceled and
	///< the changes were not committed.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_CELL_RENDERER_SIGNALS_HH

