/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  iconthemesignals.cc - Gtk::IconTheme virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib/gtypes.h>
#include "icontheme.hh"
#include "iconthemesignals.hh"
#include "private/iconthemeclass.hh"

// FIX ME: Remove GTK_ICON_THEME_GET_CLASS macro when gtkicontheme.h gets fixed (>= GTK+ 2.4.4)

#undef GTK_ICON_THEME_GET_CLASS
#define GTK_ICON_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ICON_THEME, GtkIconThemeClass))

using namespace GFC;

/*  Gtk::IconThemeSignals
 */

Gtk::IconThemeSignals::IconThemeSignals(IconTheme *icon_theme)
: G::ObjectSignals(icon_theme)
{
	Gtk::IconThemeClass::init(GTK_ICON_THEME_GET_CLASS(icon_theme->gtk_icon_theme()));
}

Gtk::IconThemeSignals::~IconThemeSignals()
{
}

void
Gtk::IconThemeSignals::on_changed()
{
	GtkIconThemeClass *g_class = IconThemeClass::get_parent_class(instance_);
	if (g_class->changed)
		g_class->changed((GtkIconTheme*)instance_);
}

/*  Gtk::IconThemeClass
 */

void
Gtk::IconThemeClass::init(GtkIconThemeClass *g_class)
{
	g_class->changed = &changed_proxy;
}

GtkIconThemeClass*
Gtk::IconThemeClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_ICON_THEME_GET_CLASS(instance));	
	return static_cast<GtkIconThemeClass*>(ptr);
}

GType
Gtk::IconThemeClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ICON_THEME);
	}
	return type;
}

void*
Gtk::IconThemeClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::IconThemeClass::changed_proxy(GtkIconTheme *icon_theme)
{
	void *ptr = g_object_get_qdata((GObject*)icon_theme, G::ObjectSignals::quark());
	if (ptr)
		static_cast<IconThemeSignals*>(ptr)->on_changed();
	else
	{
		GtkIconThemeClass *g_class = IconThemeClass::get_parent_class(icon_theme);
		if (g_class->changed)
			g_class->changed(icon_theme);
	}
}

