with Iirs; use Iirs;
with Tokens;

package Sem_Specs is
   function Get_Entity_Class_Kind (Decl : Iir) return Tokens.Token_Type;

   procedure Sem_Attribute_Specification
     (Spec : Iir_Attribute_Specification; Scope : Iir);

   --  Check declarations following an ALL/OTHERS attribute specification.
   procedure Check_Post_Attribute_Specification
     (Attr_Spec_Chain : Iir; Decl : Iir);

   procedure Sem_Disconnect_Specification
     (Dis : Iir_Disconnection_Specification);

   procedure Sem_Configuration_Specification
     (Parent_Stmts : Iir; Conf : Iir_Configuration_Specification);

   procedure Sem_Binding_Indication (Bind : Iir_Binding_Indication;
                                     Comp : Iir_Component_Declaration;
                                     Parent : Iir;
                                     Primary_Entity_Aspect : Iir);

   --  Semantize entity aspect ASPECT and return the entity declaration.
   --  Return NULL_IIR if not found.
   function Sem_Entity_Aspect (Aspect : Iir) return Iir;

   --  Semantize component_configuration or configuration_specification SPEC.
   --  STMTS is the concurrent statement list related to SPEC.
   procedure Sem_Component_Specification
     (Parent_Stmts : Iir; Spec : Iir; Primary_Entity_Aspect : out Iir);

   --  Create a default binding indication for component COMP which will be
   --  bound with entity ENTITY_UNIT.
   --  If ENTITY_UNIT is NULL_IIR, the component is not bound.
   --  If FORCE is True, a binding indication will be created even if the
   --   component is not bound (this is an open binding indication).
   --  PARENT is used to report error.
   function Sem_Create_Default_Binding_Indication
     (Comp : Iir_Component_Declaration;
      Entity_Unit : Iir_Design_Unit;
      Parent : Iir;
      Force : Boolean)
     return Iir_Binding_Indication;

   --  Create a default generic or port map aspect that associates all elements
   --  of ENTITY (if any) to elements of COMP with the same name or to
   --  an open association.
   --  If KIND is GENERIC_MAP, apply this on generics, if KIND is PORT_MAP,
   --  apply this on ports.
   --  PARENT is used to report errors.
   type Map_Kind_Type is (Map_Generic, Map_Port);
   function Create_Default_Map_Aspect
     (Comp : Iir; Entity : Iir; Kind : Map_Kind_Type; Parent : Iir)
     return Iir;

   --  Explain why there is no default binding for COMP.
   procedure Explain_No_Visible_Entity (Comp: Iir_Component_Declaration);

   function Get_Visible_Entity_Declaration (Comp: Iir_Component_Declaration)
                                           return Iir_Design_Unit;

   procedure Sem_Specification_Chain (Decls_Parent : Iir; Parent_Stmts: Iir);
end Sem_Specs;
