// $Id: statusbar.cc,v 1.18 2002/05/14 08:25:45 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

class Gtk_StatusBar : public Gtk_HBox
{public:
	typedef Gtk_HBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_StatusBar();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gtk_StatusBar Gtk_StatusBar;

const std::string Gtk_StatusBar::TypeName(const Widget &w) const
{  return GtkPrefix()+"Statusbar";
}

const std::string Gtk_StatusBar::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"statusbar.h";
}

Gtk_StatusBar::Gtk_StatusBar()
{  Writer["GtkStatusBar"]=this;
   Writer["GtkStatusbar"]=this;
}

#if 0
bool Gtk_Statusbar::SampleCode(CxxFile &f,const Widget &w,enum WriterType::CodePosition pos,const std::string misc)
{  switch(pos)
   {  case WriterType::ContainingConstructor:
         {  f << "\t" << Configuration.InstanceName(w.Name()) << "->"
              << "push(1, \"some status text\");\n";
            f << "\t" << Configuration.InstanceName(w.Name()) << "->"
              << "push(2, \"yet another status text\");\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
#endif
