#ifndef EVAX_SOLIB_H
#define EVAX_SOLIB_H

#include "target.h"

/* Called to add symbols from a shared library to gdb's symbol table. */

#define SOLIB_ADD(filename, from_tty, targ) \
    evax_solib_add (filename, from_tty, targ)

extern void
evax_solib_add PARAMS ((char *, int, struct target_ops *));

/* Function to be called when the inferior starts up, to discover the names
   of shared libraries that are dynamically linked, the base addresses to
   which they are linked, and sufficient information to read in their symbols
   at a later time. */

#define SOLIB_CREATE_INFERIOR_HOOK(PID)	evax_solib_create_inferior_hook()

extern void
evax_solib_create_inferior_hook PARAMS((void));	/* evax-solib.c */


/* If ADDR lies in a shared library, return its name.  */

#define PC_SOLIB(addr)	evax_solib_address (addr)

extern char *
evax_solib_address PARAMS ((CORE_ADDR));	/* evax-solib.c */


extern struct section_offsets *
evax_solib_offsets ();

#define FILES_INFO_HOOK	evax_files_info

extern int
evax_files_info ();

#endif


