%define    ver     1.0.2
%define    rel     1
%define    prefix  /usr

Summary: A GNOME version of the GNU "find" utility.
Summary(es): Una versin grfica para GNOME de la utilidad GNU "find".
Name: gnome-find
Version: %{ver}
Release: %{rel}
Copyright: GPL
Url: http://gnome-find.sourceforge.net
Group: Utilities/System
Source: %{name}-%{ver}.tar.gz
Requires: gnome-libs >= 1.0.53 libglade >= 0.11 gtk+ >= 1.2.0 glib >= 1.2.0
BuildRoot: /var/tmp/%{name}-root

%description
gnome-find is a graphical, GNOME version of the GNU "find" utility.

It is not just a front-end which just forks and execs "find", nor is
it a utility that reinvents the wheel by rewriting the "find" utility
itself.

The original source code to the GNU "find" utility (as found in
findutils-4.1) was used, and a GUI component was integrated into it.
Consequently, the actual file finding backend component is based on
the very stable and mature code in GNU "find", while the GUI component
provides a modern, easy-to-use interface.

By making it a truely graphical program, it avoids the common
portability problems typically encountered by front-ends when they run
on systems without GNU "find", as well as avoiding messy issues with
forking a new process and communicating with it (e.g., pipes,
temporary files, etc.).

It is by far more powerful than any other GUI-based "find" utility,
including "kfind" and "gsearchtool" (aka "GNOME Search Tool").

%description -l es
gnome-find es una versin grfica para GNOME de la utilidad GNU "find".

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
make

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc AUTHORS NEWS README TODO ChangeLog
%attr(755,root,root)
%{prefix}/bin/%{name}
%{prefix}/man/man1/%{name}.1
%{prefix}/share/*

%changelog
* Sat Jul 15 2000 Andy C. Kahn <ackahn@netapp.com>
- Fix incorrect prefix and destination in install command.  The locale
  files were being installed in a separate location, such that the
  resulting RPM did not include them.

* Wed May 17 2000 Andy C. Kahn <ackahn@netapp.com>
- Various fixes so that the RPM file actually builds.
- Spanish translation from Joel Barrios <linux@jjnet.prohosting.com>

* Mon May 08 2000 Andy C. Kahn <ackahn@netapp.com>
- Initial package
