#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
"""
Common routines for the QT driver
"""
# NOTES:
#

import string
from qt import *
from gnue.common import events

# Finishing creation of dictionary for language font encodings
encodings = {
#FIX#    'iso8859-1': wxFONTENCODING_ISO8859_1,
#FIX#    'iso8859-2': wxFONTENCODING_ISO8859_2,
#FIX#    'iso8859-3': wxFONTENCODING_ISO8859_3,
#FIX#    'iso8859-4': wxFONTENCODING_ISO8859_4,
#FIX#    'iso8859-5': wxFONTENCODING_ISO8859_5,
#FIX#    'iso8859-6': wxFONTENCODING_ISO8859_6,
#FIX#    'iso8859-7': wxFONTENCODING_ISO8859_7,
#FIX#    'iso8859-8': wxFONTENCODING_ISO8859_8,
#FIX#    'iso8859-9': wxFONTENCODING_ISO8859_9,
#FIX#    'iso8859-10': wxFONTENCODING_ISO8859_10,
#FIX#    'iso8859-11': wxFONTENCODING_ISO8859_11,
#FIX#    'iso8859-12': wxFONTENCODING_ISO8859_12,
#FIX#    'iso8859-13': wxFONTENCODING_ISO8859_13,
#FIX#    'iso8859-14': wxFONTENCODING_ISO8859_14,
#FIX#    'iso8859-15': wxFONTENCODING_ISO8859_15,
#FIX#    'koi8': wxFONTENCODING_KOI8,
#FIX#    'koi8-r': wxFONTENCODING_KOI8,
#FIX#    'cp1250': wxFONTENCODING_CP1250,
#FIX#    'cp1251': wxFONTENCODING_CP1251,
#FIX#    'cp1252': wxFONTENCODING_CP1252
   '':''
    }



# TODO: get rid of this call
def _eventObjToQtWindow(event):
  return event


#
# Little global helper routine to set font according to options
#
# TODO: Not completed
#
def initFont(widget, affectsLayout=1):
  global _font
  widget.setFont(_font)

def setWidgetBaseFont(font):
  global _font
  _font = font


#####################################################################
##
## Basic Event Processing
##
#####################################################################

def _setDefaultEventHandlers(newWidget, eventHandler, initialize, uiDriver):
  return
##  if initialize:
##    uiBaseEvtHandler(newWidget, eventHandler, uiDriver)


##
##
##
class uiBaseEvtHandler:
  def __init__(self, event, uiwidget, qtClass=None):
    self._eventHandler = event.eventHandler
    self._uiwidget = uiwidget
    self._qtClass = qtClass
    self.setFocusPolicy(QWidget.NoFocus)

  #
  # Over-ride events
  #
  def keyPressEvent(self, event):
    action = None

    uiwidget = self._uiwidget
    gfObject = uiwidget._gfObject

    keycode = event.key()
    state = event.state()
    shifted = state & QKeyEvent.ShiftButton
    control = state & QKeyEvent.ControlButton
    alt = state & QKeyEvent.AltButton

    # Get the event to process from the KeyMapper
    command = GFKeyMapper.KeyMapper.getEvent( keycode, shifted, control, alt)

    if command:
      action = events.Event('request%s' % command)

    elif not (control or alt):
      char = "%s" % event.text()
      if char:
        action = events.Event('requestKEYPRESS', char, text=char, code=keycode)

    if action:
      # Add the object's _form to the outgoing event
      # rather than every event in the function
      action.__dict__.update({'_form':gfObject._form})
      self._eventHandler(action)

  #
  # Over-ride events
  #
  def mousePressEvent(self, event):
    uiwidget = self._uiwidget
    gfObject = uiwidget._gfObject

    if not self.hasFocus():
      # Request Focus
      self._eventHandler('requestFOCUS',gfObject,_form=gfObject._form)
      count = uiwidget._uiDriver._IdToUIObj[id(self)].widgets.index(self)
      self._eventHandler('requestJUMPRECORD',count - gfObject._visibleIndex,_form=gfObject._form)

    if self._qtClass:
      self._qtClass.mousePressEvent(self, event)
    try:
      self.__cursor = self.cursorPosition()
      selected, start, end = self.getSelection()
      self._eventHandler('requestCURSORMOVE',position=self.cursorPosition(),_form=gfObject._form)
      if selected:
        self._eventHandler('requestSELECTWITHMOUSE',position1=start,position2=end,_form=gfObject._form)
    except AttributeError:
      pass # Not everything has a cursorPosition()


  def _selectionChanged(self):
    uiwidget = self._uiwidget
    gfObject = uiwidget._gfObject
    selected, start, end = self.getSelection()
    if selected:
      self._eventHandler('requestSELECTWITHMOUSE',position1=start,position2=end,_form=gfObject._form)



#####################################################################
##
## Keymapper Support
##
#####################################################################
from gnue.forms import GFKeyMapper
from gnue.forms.GFKeyMapper import vk

# Translate from QT keystrokes to our virtual keystrokes
qtKeyTranslations = {
    vk.F1     : Qt.Key_F1,        vk.F2        : Qt.Key_F2,
    vk.F3     : Qt.Key_F3,        vk.F4        : Qt.Key_F4,
    vk.F5     : Qt.Key_F5,        vk.F6        : Qt.Key_F6,
    vk.F7     : Qt.Key_F7,        vk.F8        : Qt.Key_F8,
    vk.F9     : Qt.Key_F9,        vk.F10       : Qt.Key_F10,
    vk.F11    : Qt.Key_F11,       vk.F12       : Qt.Key_F12,
    vk.INSERT : Qt.Key_Insert,    vk.DELETE    : Qt.Key_Delete,
    vk.HOME   : Qt.Key_Home,      vk.END       : Qt.Key_End,
    vk.PAGEUP : Qt.Key_Prior,     vk.PAGEDOWN  : Qt.Key_Next,
    vk.UP     : Qt.Key_Up,        vk.DOWN      : Qt.Key_Down,
    vk.LEFT   : Qt.Key_Left,      vk.RIGHT     : Qt.Key_Right,
    vk.TAB    : Qt.Key_Tab,
    vk.ENTER  : Qt.Key_Return,    vk.BACKSPACE : Qt.Key_Backspace }

GFKeyMapper.KeyMapper.setUIKeyMap(qtKeyTranslations)


