# GNU Enterprise Navigator - Client
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GNClient.py 6568 2004-10-26 14:29:09Z johannes $

import pstats
import os
import sys
import urllib

from gnue.navigator.GNParser import loadProcesses
from gnue.navigator import Actions
from gnue.common.apps import errors
from gnue.common.utils.FileUtils import openResource, dyn_import
from gnue.common.datasources import GDataObjects, GConnections
from gnue.common.apps.GClientApp import *
from gnue import paths
from gnue.navigator import VERSION
from gnue.forms.GFInstance import GFInstance

from GNConfig import ConfigOptions as NavigatorConfigOptions

# TODO: Please go away!!!!!
try:
  from gnue.forms.GFConfig import ConfigOptions
  FORMS_SUPPORT = True

except:
  FORMS_SUPPORT = False
  
try:
  from gnue.reports.base.GRConfig import ConfigOptions as ReportsConfigOptions

  REPORTS_SUPPORT = True

except:
  REPORTS_SUPPORT = False
  

# =============================================================================
# This class implements the navigator client
# =============================================================================

class GNClient (GClientApp):
  #
  # GClientApp() overrides
  #
  VERSION = VERSION
  COMMAND = "gnue-navigator"
  NAME    = "GNUe Navigator"
  USAGE   = "[options] file"
  SUMMARY = _("GNUe Navigator is the primary menuing interface to the GNU "
              "Enterprise system.")

  # ---------------------------------------------------------------------------
  # Initialize the class
  # ---------------------------------------------------------------------------

  def __init__ (self, connections = None):

    self.addCommandOption ('user_interface', 'u', 'interface', argument = "ui",
        category = "ui",
        help = _("The name of the user interface to use to display the "
                 "navigator. Currently supported interfaces are: wx, gtk2, "
                 "win32, web and text"))

    self.addCommandOption ('no-splash', 's', category = "ui",
        help = _("Disables the splash screen"))

    self.addCommandOption ('gnome_menu', None, 'install-gnome-menu',
        help = _('Installs a menu structure into your local GNOME session'))

    self.addCommandOption ('kde_menu', None, 'install-kde-menu',
        help = _('Installs a menu structure into your local KDE session'))


    GClientApp.__init__ (self, connections, 'forms', ConfigOptions)

    self.configurationManager.loadApplicationConfig (section = "navigator",
                                             defaults = NavigatorConfigOptions)
    
    if REPORTS_SUPPORT:
      self.configurationManager.loadApplicationConfig (section = "reports",
                                               defaults = ReportsConfigOptions)
      self.configurationManager.registerAlias ('gConfigReports', 'reports')
      
    self.configurationManager.registerAlias ('gConfigNav'  , 'navigator')
    self.configurationManager.registerAlias ('gConfigForms', 'forms')

    self._formInstances    = {}
    self._lastSerialNumber = 0


  # ---------------------------------------------------------------------------
  # Run the client application
  # ---------------------------------------------------------------------------

  def run (self):

    #
    # Initialize user interface
    #
    self.ui_type = self.OPTIONS ['user_interface']
    if self.ui_type:
      SPECIFIC_UI = True
    else:
      SPECIFIC_UI = False
      self.ui_type = gConfigForms ('DefaultUI')

    while True:
      try:
        self._ui = dyn_import ("gnue.navigator.UI%s" % self.ui_type)
        break

      except ImportError:
        gDebug (1, "Unable to load UI driver %s" % self.ui_type)
        gDebug (1, "Error: %s" % errors.getException () [2])

        # If user specified a specific UI, don't cycle...
        if SPECIFIC_UI:
          raise StartupError, \
              u_("Unable to load any valid UI drivers: %s") \
              % errors.getException () [2]

        if self.ui_type != 'text':
          self.ui_type = 'text'

        else:
          raise StartupError, u_("Unable to load any valid UI driver.")

    # if we have a forms-uidriver available take over it's exception handling
    # and set the login handler for the connection manager.
    if hasattr (self._ui, 'ui'):
      instance = GFInstance (self, self.connections, self._ui.ui, False)
      self._showException = instance._uiinstance.showException

      loginHandler = self._ui.ui.UILoginHandler ()
      loginHandler.uiDriver = instance._uiinstance
      self.connections.setLoginHandler (loginHandler)

    #
    # assign menu file from 1st free argument
    #
    if len (self.ARGUMENTS):
      processFile = self.ARGUMENTS [0]

    else:
      basename = os.path.basename (sys.argv [0]).lower ().split ('.') [0]
      if basename not in ['gnue-navigator','gncvs']:
        processFile = os.path.join (paths.data, gConfigNav ('ProcessDir'),
                                    os.path.basename (sys.argv [0])) + ".gpd"
      else:
        raise StartupError, u_("No process definition file specified")


    fileHandle = openResource (processFile)
    try:
      nav = loadProcesses (fileHandle)

      # add some information to the top object
      nav._connections   = self.connections
      nav._configManager = self.configurationManager
      nav._ui_type       = self.ui_type

    finally:
      fileHandle.close ()


    # Handle any action commands
    if self.OPTIONS ['kde_menu']:
      from gnue.navigator.Actions import kde_menu

      kde_menu.run (nav, self.ARGUMENTS [1:])
      sys.exit ()

    if self.OPTIONS ['gnome_menu']:
      from gnue.navigator.Actions import gnome_menu

      gnome_menu.run (nav, self.ARGUMENTS [1:])
      sys.exit ()


    if gConfigNav ('disableSplash'):
      self.disableSplash = True
    else:
      self.disableSplash = self.OPTIONS ['splash_screen']

    self._ui.Instance (nav).run (self.connections)


# =============================================================================
# Main program
# =============================================================================

if __name__ == '__main__':
  GNClient ().run ()


