<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gnue="GNUe:Reports:Base"
  xmlns:t="GNUe:Reports:SimpleTabulation">

<xsl:output method="xml" indent="yes"/>

<!-- Paper Size -->
<xsl:param name="paper-width" >8.5in</xsl:param>
<xsl:param name="paper-height">11in</xsl:param>


<xsl:template match="/">
  <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <fo:layout-master-set>
      <fo:simple-page-master margin-top="5mm" margin-right="25mm" margin-bottom="5mm" margin-left="25mm" master-name="PageMaster">
        <xsl:attribute name="page-height">
          <xsl:value-of select="$paper-height"/>
        </xsl:attribute>
        <xsl:attribute name="page-width">
          <xsl:value-of select="$paper-width"/>
        </xsl:attribute>
        <fo:region-body margin-top="2cm" margin-right="0cm" margin-bottom="2cm" margin-left="0cm"/>
        <fo:region-before border-after-style="solid" border-width="1pt" extent="2cm" display-align="after"/>
        <fo:region-after border-before-style="solid" border-width="1pt" extent="1cm" display-align="before"/>
      </fo:simple-page-master>
    </fo:layout-master-set>
    <xsl:call-template name="doPageSequence"/>
  </fo:root>
</xsl:template>


<xsl:template name="doPageSequence">
  <fo:page-sequence master-reference="PageMaster">
  
    <fo:static-content flow-name="xsl-region-before">
      <fo:block text-decoration="underline" text-align="center" font-weight="bold">
          <xsl:value-of select="gnue:report-output/t:report/t:reportTitle"/>
      </fo:block>
      <fo:block space-after="0.5cm" text-align="center">
          <xsl:value-of select="gnue:report-output/t:report/t:reportSubTitle"/>
      </fo:block>
      <xsl:call-template name="doColhead"/>  
    </fo:static-content>
    
    <fo:static-content flow-name="xsl-region-after">
      <fo:block text-align="center" font-size="small">
        - <fo:page-number/> -
      </fo:block>
    </fo:static-content>
    
    <fo:flow flow-name="xsl-region-body" >
      <fo:block>
        <xsl:for-each select="gnue:report-output/t:report/t:section">
          <fo:block>
            <xsl:apply-templates select="t:sectionTitle"/>
          </fo:block>
          <xsl:call-template name="doTable"/>
        </xsl:for-each>
      </fo:block>
    </fo:flow>
  </fo:page-sequence>
</xsl:template>


<xsl:template name ="doColhead">
  <fo:table border-collapse="collapse" width="100%" background-color="black" color="white"
    <xsl:for-each select="gnue:report-output/t:report/t:section/t:table/t:tablehead/t:colhead">
      <fo:table-column/>
    </xsl:for-each>
    <fo:table-body
    <fo:table-row
      <xsl:for-each select="gnue:report-output/t:report/t:section/t:table/t:tablehead/t:colhead">
        <fo:table-cell >
            <xsl:element name="fo:block">
              <xsl:if test="@align">
                <xsl:attribute name="text-align"><xsl:value-of select="@align"/></xsl:attribute>
              </xsl:if>  
              <xsl:value-of select="."/>
            </xsl:element>
        </fo:table-cell>
      </xsl:for-each>
    </fo:table-row
    </fo:table-body
  </fo:table
</xsl:template>


<xsl:template name ="doTable">
  <fo:table border-collapse="collapse" width="80%"
    <xsl:for-each select="t:table/t:tablehead/t:colhead">
      <fo:table-column/>
    </xsl:for-each>
    <fo:table-body>
    <xsl:for-each select="t:table/t:group">
    <xsl:for-each select="t:row">
      <xsl:variable name="rowCount" select="position()"/>
      <xsl:variable name="rowType" select="@type"/>
      <fo:table-row>
        <xsl:for-each select="t:col">
          <fo:table-cell>
            <xsl:element name="fo:block">
              <xsl:if test="@align">
                <xsl:attribute name="text-align"><xsl:value-of select="@align"/></xsl:attribute>
              </xsl:if>
              <xsl:if test="$rowType = &quot;subtotal&quot;">
                <xsl:attribute name="font-weight">bold</xsl:attribute>
                <xsl:attribute name="space-after">0.5cm</xsl:attribute>
              </xsl:if>
              <xsl:choose>
                <xsl:when test="t:supressRepeatedValues">
                  <xsl:choose>
                    <xsl:when test="$rowCount=1"><xsl:value-of select="."/></xsl:when>
                    <xsl:otherwise><xsl:text> </xsl:text></xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
              </xsl:choose>
            </xsl:element>
          </fo:table-cell>
        </xsl:for-each>
      </fo:table-row>
    </xsl:for-each
    </xsl:for-each
    </fo:table-body
  </fo:table
</xsl:template>


</xsl:stylesheet>
