indexing

	description:

		"System clocks (precision to the second)"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2001, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/26 20:05:29 $"
	revision: "$Revision: 1.9 $"

class KL_SYSTEM_CLOCK

inherit

	KI_SYSTEM_CLOCK













































creation

	make

feature {NONE} -- Initialization

	make is
			-- Create a new system clock.
		do



		end


feature -- Access

	year: INTEGER
			-- Year

	month: INTEGER
			-- Month

	day: INTEGER
			-- Day

	hour: INTEGER
			-- Hour

	minute: INTEGER
			-- Minute

	second: INTEGER
			-- Second


feature -- Setting

	set_local_time is
			-- Set clock to current local time.






		local
			old_is_local: BOOLEAN

		do

			old_is_local := basic_time.is_local_time
			basic_time.set_local_time
			basic_time.update
			year := basic_time.year
			month := basic_time.month
			day := basic_time.day
			hour := basic_time.hour
			minute := basic_time.minute
			second := basic_time.second
			if not old_is_local then
				basic_time.set_universal_time
			end

















		end

	set_utc_time is
			-- Set clock to current UTC time.






		local
			old_is_local: BOOLEAN

		do

			old_is_local := basic_time.is_local_time
			basic_time.set_universal_time
			basic_time.update
			year := basic_time.year
			month := basic_time.month
			day := basic_time.day
			hour := basic_time.hour
			minute := basic_time.minute
			second := basic_time.second
			if old_is_local then
				basic_time.set_local_time
			end

















		end


feature {NONE} -- Implementation


	basic_time: TIME
			-- System time















































































end
