indexing

	description:

		"Test singleton pattern"

	library: "Gobo Eiffel Pattern Library"
	copyright: "Copyright (c) 2002, Berend de Boer and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:20:33 $"
	revision: "$Revision: 1.5 $"

deferred class DP_TEST_SINGLETON

inherit

	TS_TEST_CASE

	SHARED_SINGLETON1
	SHARED_SINGLETON2
	SHARED_SINGLETON3
	SHARED_SINGLETON4

feature -- Tests

	test_single_singleton is
			-- Can we create a singleton?
		local
			s1: SINGLETON1
		do
			if not singleton1_created then
				create s1.make
				assert ("singleton1_created", singleton1_created)
				assert ("singleton1", s1 = singleton1)
			end
		end

	test_two_singletons_in_system is
			-- What if we have two singleton classes in our system?
		local
			s2: SINGLETON2
		do
			if not singleton2_created then
				create s2.make
				assert ("singleton2_created", singleton2_created)
				assert ("singleton2", s2 = singleton2)
			end
		end

	test_singleton_accessor is
			-- Does the accessor work?
		local
			first, second: SINGLETON3
		do
			first := singleton3
			assert ("singleton3_not_void", first /= Void)
			second := singleton3
			assert ("singleton3_pattern", first = second)
		end

	test_another_singleton_accessor is
			-- Do two singleton accessors work?
		local
			first, second: SINGLETON4
			s4: ANY
		do
			first := singleton4
			assert ("singleton4_not_void", first /= Void)
			second := singleton4
			assert ("singleton4_pattern", first = second)
				-- Workaround for VWEQ:
			s4 := first
			assert ("different_singletons", s4 /= singleton3)
		end

end
