/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PG_DATABASE_METADATA_H)
#define __INC_PG_DATABASE_METADATA_H

#include "gql++/database-metadata.h"
#include "gql++/mod-result-set.h"
#include "connection.h"

namespace GQL
{

namespace MySQL
{

class MyDatabaseMetaData : public DatabaseMetaData
{
  public:
    MyDatabaseMetaData(MyConnection *conn) : conn_(conn) { }
    
    virtual ResultSet *get_tables(const std::string& catalog,
                                  const std::string& schema_pattern,
                                  const std::string& table_name_pattern,
                                  const std::vector<std::string>& types);
    
    virtual ResultSet *get_columns(const std::string& catalog,
                                   const std::string& schema,
                                   const std::string& table_name_pattern,
                                   const std::string& column_name_pattern);

    virtual ResultSet *get_primary_keys(const std::string& catalog,
                                        const std::string& schema,
                                        const std::string& table) {
      return SigC::manage(new ModResultSet(conn_, 6));
    }
    
    virtual ResultSet *get_cross_reference(
            const std::string& primary_catalog,
            const std::string& primary_schema,
            const std::string& primary_table,
            const std::string& foreign_catalog,
            const std::string& foreign_schema,
            const std::string& foreign_table);
    
    virtual ResultSet *get_imported_keys(const std::string& cat,
                                         const std::string& schema,
                                         const std::string& table) {
      return get_cross_reference("null", "null", "", "null", "null", table);
    }
    
    virtual ResultSet *get_exported_keys(const std::string& cat,
                                         const std::string& schema,
                                         const std::string& table) {
      return get_cross_reference("null", "null", table, "null", "null", "");
    }
    virtual ResultSet *get_index_info(const std::string& cat,
                                      const std::string& schema,
                                      const std::string& table,
                                      bool unique,
                                      bool approximate) {
      return manage(new ModResultSet(conn_, 13));
    }
  private:
    MyConnection *conn_;
};

}

}

#endif
