#include "result-set.h"
#include "result-set-metadata.h"

namespace GQL
{

namespace MySQL
{

MyResultSet::MyResultSet(MyConnection *conn, MYSQL_RES *result)
    : ResultSet(conn) 
{
  result_ = result;
  rowno_ = -1;
  metadata_ = 0;
}

MyResultSet::~MyResultSet()
{
  if (result_)
    mysql_free_result(result_);
  if (metadata_)
    metadata_->unreference();
}

bool MyResultSet::next() throw(SQLException)
{
  if (result_ && (int)mysql_num_rows(result_) > rowno_ + 1)
  {
    rowno_++;
    row_ = mysql_fetch_row(result_);
    return(true);
  }
  return(false);
}

SQLObject *MyResultSet::get(int i, SQLObject *obj) const throw(SQLException)
{
  if (!row_)
    throw SQLException("ResultSet does not contain any data");

  if (i < 0 || i >= (int)mysql_num_fields(result_))
    throw SQLException("Attempt to access invalid field");

  if (row_[i] == 0)
  {
    obj->set_null();
    return obj;
  }
  
  obj->from_string(row_[i]);

  return obj;
}

const ResultSetMetaData *MyResultSet::get_meta_data() const
{
  if (!metadata_)
  {
    MyResultSet *me = const_cast<MyResultSet *>(this);
    
    me->metadata_ = manage(new MyResultSetMetaData(
                                   me->get_connection(), result_));
    me->metadata_->reference();
  }

  return metadata_;
}

}

}
