#include "gql++/result-set.h"
#include "gql++/object.h"

#include "connection.h"
#include "result-set-metadata.h"

namespace GQL
{
  
namespace PG
{

PGResultSetMetaData::PGResultSetMetaData(Connection *conn, PGresult *result)
{
  conn_ = conn;
  result_ = result;
  column_types_ = new SQLType[column_count()];
}

PGResultSetMetaData::~PGResultSetMetaData()
{
  delete[] column_types_;
}

int PGResultSetMetaData::column_count() const
{
  return(result_ ? PQnfields(result_) : 0);
}

string PGResultSetMetaData::get_column_label(int i) const
{
  string result = result_ && i >= 0 && i < column_count() ?
    PQfname(result_, i) : string();

  return(result);
}

string PGResultSetMetaData::get_column_name(int i) const
{
  string result = result_ && i >= 0 && i < column_count() ?
    PQfname(result_, i) : string();

  return(result);
}

#include "type_table.cc"

const SQLType& PGResultSetMetaData::get_column_type(int i) const
{
  if (conn_ && result_ && column_types_ && i >= 0 && i < column_count())
  {
    if (column_types_[i].typecode() == SQLType::VOID)
    {
      string type_name;
      char oid_string[64];
      Oid type_oid;
      SQLType *the_type = &column_types_[i];
      PGConnection *pg_conn = &dynamic_cast<PGConnection&>(*conn_);
      PGresult *res;
      
      type_oid = PQftype(result_, i);
      sprintf(oid_string, "%i", type_oid);
      res = pg_conn->exec_sql(string("SELECT typname FROM pg_type "
                                     "  WHERE oid = ") + oid_string);

      if (PQntuples(res) == 1)
        type_name = PQgetvalue(res, 0, 0);
      
      PQclear(res);
      
      Type *type = lookup_type(type_name.c_str(), type_name.length());

      if (type)
      {
        switch (type->typecode)
        {
          case SQLType::CHARACTER:
          case SQLType::CHARACTER_VARYING:
            *the_type = SQLType(type->typecode, PQfmod(result_, i) - 4);
            break;
          case SQLType::FLOAT:
            *the_type = SQLType(SQLType::FLOAT, 
				PQfsize(result_, i) == 8 ? 15 : 6);
            break;
          case SQLType::NUMERIC:
            *the_type = SQLType(SQLType::NUMERIC, PQfsize(result_, i), 
                                PQfmod(result_, i));
            break;
	default:
            *the_type = SQLType(type->typecode);
            break;
	}
      }
    }
    return column_types_[i];
  }
  
  throw SQLException("invalid call to PGResultSetMetaData::get_column_type");
}

}

}
