/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_EXCEPTION_H)
#define __INC_EXCEPTION_H

#include <stdexcept>

namespace GQL
{

class SQLException : public std::runtime_error
{
  public:
    SQLException(const std::string& str = std::string(),
                 const std::string& state = std::string(),
                 int err = 0)
        : runtime_error(str), state_(state), vendor_code_(err) { }
    virtual ~SQLException() throw() { }

    const char *get_message() const { return(what()); }
    int get_error_code() const { return(vendor_code_); }
    const std::string& get_sql_state() const { return(state_); }
  private:
    std::string state_;
    int vendor_code_;
};

}

#endif
